/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VariateHeightLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> LOWEST_BRANCH_VARIATION = ConfigurationProperty.integer((String)"lowest_branch_variation");

    public VariateHeightLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_VARIATION, (Object)6);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{HEIGHT_VARIATION});
    }

    public static int getHashedVariation(World world, BlockPos pos, int heightVariation) {
        long day = world.func_82737_E() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)2) % heightVariation;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        World world = context.world();
        BlockPos pos = context.pos();
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(world, pos) + (float)VariateHeightLogic.getHashedVariation(world, pos, (Integer)configuration.get(HEIGHT_VARIATION));
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getLowestBranchHeight(configuration, context) + VariateHeightLogic.getHashedVariation(context.world(), context.pos(), (Integer)configuration.get(HEIGHT_VARIATION));
    }
}

