/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TwistingTreeLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Float> CHANCE_TO_SPLIT = ConfigurationProperty.floatProperty((String)"chance_to_split");
    public static final ConfigurationProperty<Integer> DOWN_PROBABILITY = ConfigurationProperty.integer((String)"down_probability");
    public static final ConfigurationProperty<Boolean> SPLIT_ENDS = ConfigurationProperty.bool((String)"split_ends");

    public TwistingTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CHANCE_TO_SPLIT, (Object)Float.valueOf(0.01f))).with(DOWN_PROBABILITY, (Object)0)).with(HEIGHT_VARIATION, (Object)3)).with(SPLIT_ENDS, (Object)true);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_SPLIT, DOWN_PROBABILITY, HEIGHT_VARIATION, SPLIT_ENDS});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        World world = context.world();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.func_176734_d();
        int count = 0;
        for (Direction direction : Direction.values()) {
            int rad = TreeHelper.getRadius((IBlockReader)world, (BlockPos)pos.func_177971_a(direction.func_176730_m()));
            if (rad > 0) {
                ++count;
            }
            probMap[direction.ordinal()] = rad + (world.func_201674_k().nextFloat() < ((Float)configuration.get(CHANCE_TO_SPLIT)).floatValue() ? 1 : 0);
        }
        if (count <= 1 || ((Boolean)configuration.get(SPLIT_ENDS)).booleanValue() && signal.energy < 3.0f) {
            probMap[0] = (Integer)configuration.get(DOWN_PROBABILITY);
            probMap[1] = context.species().getUpProbability();
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.world().func_82737_E() / 24000L;
        int month = (int)day / 30;
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.world(), context.pos()) + (float)(CoordUtils.coordHashCode((BlockPos)context.pos().func_177981_b(month), (int)3) % (Integer)configuration.get(HEIGHT_VARIATION));
    }
}

