/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaperedWitheredOakLogic
extends ConiferLogic {
    public TaperedWitheredOakLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(ENERGY_DIVISOR, (Object)Float.valueOf(6.0f))).with(HORIZONTAL_LIMITER, (Object)Float.valueOf(6.0f))).with(HEIGHT_VARIATION, (Object)7);
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Species species = context.species();
        World world = context.world();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        int radius = context.radius();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.func_176734_d();
        int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)2);
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() ? species.getUpProbability() : 1;
        probMap[5] = 0;
        probMap[4] = 0;
        probMap[3] = 0;
        probMap[2] = 0;
        int lowestBranch = species.getLowestBranchHeight();
        int height = lowestBranch * 2 + treeHash % 7829 % 3;
        if (signal.delta.func_177956_o() >= height) {
            probMap[5] = !signal.isInTrunk() || radius > 1 ? 2 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            probMap[originDir.ordinal()] = 0;
            int n = signal.dir.ordinal();
            probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        } else if (signal.delta.func_177956_o() == lowestBranch) {
            if (!signal.isInTrunk()) {
                probMap[1] = signal.energy >= 2.0f ? 0 : 1;
                probMap[5] = signal.energy >= 3.0f ? 0 : 1;
                probMap[4] = probMap[5];
                probMap[3] = probMap[5];
                probMap[2] = probMap[5];
                probMap[originDir.ordinal()] = 1;
            } else {
                int sideHash = treeHash % 16;
                probMap[2] = sideHash % 2 < 1 ? 1 : 0;
                probMap[3] = sideHash % 4 < 2 ? 1 : 0;
                probMap[4] = sideHash % 8 < 4 ? 1 : 0;
                probMap[5] = sideHash < 8 ? 1 : 0;
            }
        }
        probMap[originDir.ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Species species = context.species();
        GrowSignal signal = context.signal();
        Direction newDir = super.selectNewDirection(configuration, context);
        if (signal.delta.func_177956_o() == species.getLowestBranchHeight() && signal.isInTrunk() && newDir != Direction.UP) {
            signal.energy = 5.0f;
        }
        return newDir;
    }
}

