/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import maxhyper.dtbyg.growthlogic.VariateHeightLogic;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SythianLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> THICKEN_THRESHOLD = ConfigurationProperty.integer((String)"thicken_threshold");

    public SythianLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(THICKEN_THRESHOLD, (Object)5)).with(HEIGHT_VARIATION, (Object)13);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{THICKEN_THRESHOLD, HEIGHT_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.func_176734_d();
        probMap[0] = 0;
        int n = probMap[1] = signal.isInTrunk() ? context.species().getUpProbability() : 0;
        probMap[5] = !signal.isInTrunk() || signal.isInTrunk() && signal.numSteps % 2 == 0 ? 1 + (signal.isInTrunk() ? (int)((float)signal.delta.func_177956_o() / (configuration.getEnergy((PositionalSpeciesContext)context) / 4.0f)) : 0) : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        GrowSignal signal = context.signal();
        int threshold = (Integer)configuration.get(THICKEN_THRESHOLD);
        Direction newDir = super.selectNewDirection(configuration, context);
        if (signal.isInTrunk() && newDir != Direction.UP) {
            int y = signal.delta.func_177956_o();
            boolean extra = y > threshold && (float)y < configuration.getEnergy((PositionalSpeciesContext)context) - (float)threshold;
            signal.energy = 1.5f + (float)(extra ? 1 : 0);
            signal.energy = 0.5f;
        }
        return newDir;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        World world = context.world();
        BlockPos pos = context.pos();
        float energy = super.getEnergy(configuration, context) + (float)VariateHeightLogic.getHashedVariation(world, pos, (Integer)configuration.get(HEIGHT_VARIATION));
        if ((int)energy % 2 == 0) {
            return energy + 1.0f;
        }
        return energy + 0.5f;
    }
}

