/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import maxhyper.dtbyg.growthlogic.VariateHeightLogic;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedwoodLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Integer> HEIGHT_OF_CANOPY = ConfigurationProperty.integer((String)"height_of_canopy");

    public RedwoodLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_OF_CANOPY, (Object)8)).with(HEIGHT_VARIATION, (Object)18)).with(LOWEST_BRANCH_VARIATION, (Object)5);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{HEIGHT_OF_CANOPY, HEIGHT_VARIATION, LOWEST_BRANCH_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Species species = context.species();
        World world = context.world();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        int radius = context.radius();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.func_176734_d();
        int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)2);
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() ? species.getUpProbability() : 0;
        boolean branchOut = (signal.numSteps + treeHash) % 5 == 0;
        int sideTurn = !signal.isInTrunk() || signal.isInTrunk() && branchOut && radius > 1 ? 2 : 0;
        int canopyHeight = species.getLowestBranchHeight() + treeHash % 8 + (Integer)configuration.get(HEIGHT_OF_CANOPY);
        if (signal.delta.func_177956_o() < canopyHeight) {
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
            probMap[2 + RedwoodLogic.getHashedVariation((World)world, (BlockPos)pos, (int)4)] = sideTurn;
        } else {
            probMap[5] = !signal.isInTrunk() || signal.isInTrunk() && signal.numSteps % 4 == 1 && radius > 1 ? 2 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
        }
        probMap[originDir.ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        if (!signal.isInTrunk() && signal.numTurns == 1 && signal.delta.func_218140_a(0.0, (double)signal.delta.func_177956_o(), 0.0, false) <= 1.5) {
            probMap[signal.dir.func_176735_f().ordinal()] = 0;
            probMap[signal.dir.func_176746_e().ordinal()] = 0;
        }
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Species species = context.species();
        GrowSignal signal = context.signal();
        Direction newDir = super.selectNewDirection(configuration, context);
        int signalY = signal.delta.func_177956_o();
        int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)2);
        int canopyHeight = species.getLowestBranchHeight() + treeHash % 8 + (Integer)configuration.get(HEIGHT_OF_CANOPY);
        float bottomSlope = 1.0f + (float)(treeHash % 10) / 4095.0f;
        if (signal.isInTrunk() && newDir != Direction.UP) {
            if (signalY < canopyHeight) {
                signal.energy = 3.0f;
            } else {
                signal.energy += 2.0f;
                signal.energy /= 3.2f;
                float maxEnergy = Math.max(2.0f, Math.min(8.2f, (float)(signalY - canopyHeight) * bottomSlope));
                signal.energy = Math.min(maxEnergy, signal.energy);
            }
        }
        return newDir;
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getLowestBranchHeight(configuration, context) + (int)((double)RedwoodLogic.getHashedVariation(context.world(), context.pos(), (Integer)configuration.get(LOWEST_BRANCH_VARIATION)) * 0.5);
    }
}

