/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import maxhyper.dtbyg.growthlogic.TwistingTreeLogic;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EtherTreeLogic
extends TwistingTreeLogic {
    public static final ConfigurationProperty<Float> CANOPY_SIDE_ENERGY = ConfigurationProperty.floatProperty((String)"canopy_side_energy");
    public static final ConfigurationProperty<Integer> HEIGHT_BETWEEN_CANOPY_LAYERS = ConfigurationProperty.integer((String)"height_between_canopy_layers");

    public EtherTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CHANCE_TO_SPLIT, (Object)Float.valueOf(0.0f))).with(DOWN_PROBABILITY, (Object)0)).with(HEIGHT_VARIATION, (Object)30)).with(CANOPY_SIDE_ENERGY, (Object)Float.valueOf(15.0f))).with(HEIGHT_BETWEEN_CANOPY_LAYERS, (Object)8)).with(SPLIT_ENDS, (Object)true);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_SPLIT, DOWN_PROBABILITY, HEIGHT_VARIATION, SPLIT_ENDS, CANOPY_SIDE_ENERGY, HEIGHT_BETWEEN_CANOPY_LAYERS});
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        World world = context.world();
        BlockPos pos = context.pos();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        float maxEnergy = configuration.getEnergy((PositionalSpeciesContext)context);
        int HBCL = (Integer)configuration.get(HEIGHT_BETWEEN_CANOPY_LAYERS);
        if (signal.delta.func_177956_o() % HBCL == 0) {
            probMap[0] = (Integer)configuration.get(DOWN_PROBABILITY);
            probMap[1] = TreeHelper.isBranch((BlockState)world.func_180495_p(pos.func_177977_b())) ? context.species().getUpProbability() : 0;
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
            probMap[signal.dir.func_176734_d().ordinal()] = 0;
            return probMap;
        }
        return super.populateDirectionProbabilityMap(configuration, context);
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        GrowSignal signal = context.signal();
        int HBCL = (Integer)configuration.get(HEIGHT_BETWEEN_CANOPY_LAYERS);
        if (signal.delta.func_177956_o() % HBCL == 0 && newDir != Direction.UP) {
            signal.energy = Math.max(signal.energy, ((Float)configuration.get(CANOPY_SIDE_ENERGY)).floatValue());
        }
        return newDir;
    }
}

