/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import maxhyper.dtbyg.growthlogic.VariateHeightLogic;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class AraucariaLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Float> CANOPY_HEIGHT_FACTOR = ConfigurationProperty.floatProperty((String)"canopy_height_factor");
    public static final ConfigurationProperty<Float> SPLIT_HEIGHT_FACTOR = ConfigurationProperty.floatProperty((String)"split_height_factor");

    public AraucariaLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_HEIGHT_FACTOR, (Object)Float.valueOf(0.8f))).with(SPLIT_HEIGHT_FACTOR, (Object)Float.valueOf(0.6f))).with(HEIGHT_VARIATION, (Object)13)).with(LOWEST_BRANCH_VARIATION, (Object)7);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CANOPY_HEIGHT_FACTOR, SPLIT_HEIGHT_FACTOR, HEIGHT_VARIATION, LOWEST_BRANCH_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        float energy = context.species().getEnergy(context.world(), signal.rootPos);
        float splitCanopyHeight = energy * ((Float)configuration.get(SPLIT_HEIGHT_FACTOR)).floatValue();
        if ((float)signal.delta.func_177956_o() > splitCanopyHeight && signal.isInTrunk() || (float)signal.delta.func_177956_o() > energy * ((Float)configuration.get(CANOPY_HEIGHT_FACTOR)).floatValue()) {
            probMap[Direction.UP.ordinal()] = 0;
        }
        if ((float)signal.delta.func_177956_o() < splitCanopyHeight) {
            if (signal.numTurns == 1 && signal.delta.func_218140_a(0.0, (double)signal.delta.func_177956_o(), 0.0, true) <= 1.0) {
                probMap[Direction.UP.ordinal()] = 0;
            }
            if (signal.isInTrunk()) {
                int n = Direction.UP.ordinal();
                probMap[n] = probMap[n] * 10;
            }
        }
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        GrowSignal signal = context.signal();
        Direction newDir = super.selectNewDirection(configuration, context);
        float energy = context.species().getEnergy(context.world(), signal.rootPos);
        if (signal.isInTrunk() && newDir != Direction.UP && (float)signal.delta.func_177956_o() < energy * ((Float)configuration.get(SPLIT_HEIGHT_FACTOR)).floatValue()) {
            signal.energy = Math.min(2.5f, signal.energy);
        }
        return newDir;
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getLowestBranchHeight(configuration, context) + AraucariaLogic.getHashedVariation(context.world(), context.pos(), (Integer)configuration.get(LOWEST_BRANCH_VARIATION));
    }
}

