/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.mojang.datafixers.util.Pair;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class BranchSproutsGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> SPROUT_BLOCK = ConfigurationProperty.property((String)"sprout_block", Block.class);
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"min_radius");

    public BranchSproutsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{SPROUT_BLOCK, FRUITING_RADIUS, PLACE_CHANCE, MAX_COUNT, MIN_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SPROUT_BLOCK, (Object)Blocks.field_150350_a)).with(FRUITING_RADIUS, (Object)8)).with(PLACE_CHANCE, (Object)Float.valueOf(0.05f))).with(MAX_COUNT, (Object)16)).with(MIN_RADIUS, (Object)3);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos rootPos;
        IWorld world = context.world();
        BlockState blockState = world.func_180495_p((rootPos = context.pos()).func_177984_a());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS)) {
            int count = 1 + world.func_201674_k().nextInt((Integer)configuration.get(MAX_COUNT));
            this.placeSprouts(count, configuration, world, rootPos);
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        BlockPos rootPos;
        if (context.fertility() == 0) {
            return false;
        }
        IWorld world = context.world();
        BlockState blockState = world.func_180495_p((rootPos = context.pos()).func_177984_a());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural() && world.func_201674_k().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            this.placeSprouts(1, configuration, world, rootPos);
        }
        return true;
    }

    private void placeSprouts(int count, GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos) {
        WeightedList validSpots = new WeightedList();
        FindSidedBlockNode sproutPlacer = new FindSidedBlockNode((WeightedList<Pair<BlockPos, Direction>>)validSpots, (Integer)configuration.get(MIN_RADIUS));
        TreeHelper.startAnalysisFromRoot((IWorld)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{sproutPlacer}));
        if (!validSpots.func_234005_b_()) {
            for (int i = 0; i < count; ++i) {
                Pair selection = (Pair)validSpots.func_226318_b_(world.func_201674_k());
                BlockPos pos = (BlockPos)selection.getFirst();
                Block block = (Block)configuration.get(SPROUT_BLOCK);
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == block) {
                    return;
                }
                world.func_180501_a(pos, (BlockState)block.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)selection.getSecond()), 3);
            }
        }
    }

    public static class FindSidedBlockNode
    implements NodeInspector {
        private final WeightedList<Pair<BlockPos, Direction>> validSpots;
        private final int minRadius;

        public FindSidedBlockNode(WeightedList<Pair<BlockPos, Direction>> spots, int minRadius) {
            this.validSpots = spots;
            this.minRadius = minRadius;
        }

        public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
            int radius = TreeHelper.getRadius((IBlockReader)world, (BlockPos)pos);
            if (TreeHelper.isBranch((BlockState)blockState) && radius >= this.minRadius) {
                boolean found = false;
                for (Direction dir : CoordUtils.HORIZONTALS) {
                    BlockPos offsetPos = pos.func_177971_a(dir.func_176730_m());
                    BlockState offsetState = world.func_180495_p(offsetPos);
                    if (offsetState.func_185904_a() != Material.field_151579_a && !(offsetState.func_177230_c() instanceof TrunkShellBlock)) continue;
                    this.validSpots.func_226313_a_((Object)new Pair((Object)offsetPos, (Object)dir), radius);
                    found = true;
                }
                return found;
            }
            return false;
        }

        public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
            return false;
        }
    }
}

