/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.trees.Species;
import corgiaoc.byg.core.world.BYGConfiguredFeatures;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class BYGHugeMushroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MAX_ATTEMPTS = ConfigurationProperty.integer((String)"max_attempts");
    public static final ConfigurationProperty<Float> CHANCE_FOR_MINI = ConfigurationProperty.floatProperty((String)"chance_for_mini");
    private static final String[] fungusSoils = new String[]{"dirt_like", "fungus_like"};
    private static final WeightedList<ConfiguredFeature<?, ?>> mushrooms = new WeightedList();
    private static final WeightedList<ConfiguredFeature<?, ?>> smallMushrooms = new WeightedList();
    private static final WeightedList<ConfiguredFeature<?, ?>> glowshrooms = new WeightedList();
    private static final WeightedList<ConfiguredFeature<?, ?>> flowers = new WeightedList();
    private static final int height = 5;

    public BYGHugeMushroomGenFeature(ResourceLocation registryName) {
        super(registryName);
        this.setMushrooms();
    }

    protected void setMushrooms() {
        mushrooms.func_226313_a_((Object)BYGConfiguredFeatures.GREEN_MUSHROOM_HUGE, 1).func_226313_a_((Object)BYGConfiguredFeatures.WOOD_BLEWIT_HUGE, 1).func_226313_a_((Object)BYGConfiguredFeatures.WEEPING_MILKCAP_HUGE, 1).func_226313_a_((Object)BYGConfiguredFeatures.BLACK_PUFF_HUGE, 1);
        smallMushrooms.func_226313_a_((Object)BYGConfiguredFeatures.GREEN_MUSHROOM_MINI, 1).func_226313_a_((Object)BYGConfiguredFeatures.WOOD_BLEWIT_MINI, 1).func_226313_a_((Object)BYGConfiguredFeatures.WEEPING_MILKCAP_MINI, 1).func_226313_a_((Object)BYGConfiguredFeatures.BLACK_PUFF_MINI, 1);
        glowshrooms.func_226313_a_((Object)BYGConfiguredFeatures.PURPLE_GLOWSHROOM_HUGE, 9).func_226313_a_((Object)BYGConfiguredFeatures.BLUE_GLOWSHROOM_HUGE, 1);
        flowers.func_226313_a_((Object)BYGConfiguredFeatures.GIANT_ANGELICA_FLOWER, 2).func_226313_a_((Object)BYGConfiguredFeatures.GIANT_DANDELION_FLOWER, 2).func_226313_a_((Object)BYGConfiguredFeatures.GIANT_IRIS_FLOWER, 5).func_226313_a_((Object)BYGConfiguredFeatures.GIANT_ROSE_FLOWER, 1);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{PLACE_CHANCE, MAX_COUNT, MAX_ATTEMPTS, CHANCE_FOR_MINI});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(PLACE_CHANCE, (Object)Float.valueOf(0.4f))).with(MAX_COUNT, (Object)1)).with(MAX_ATTEMPTS, (Object)3)).with(CHANCE_FOR_MINI, (Object)Float.valueOf(0.2f));
    }

    private BlockPos findFloor(Species species, IWorld world, BlockPos startPos) {
        for (int i = -5; i < 5; ++i) {
            BlockPos thisPos = startPos.func_177981_b(i);
            BlockPos upPos = thisPos.func_177984_a();
            if (!species.isAcceptableSoil(world.func_180495_p(thisPos)) || !world.func_180495_p(upPos).func_185904_a().func_76222_j()) continue;
            return thisPos;
        }
        return BlockPos.field_177992_a;
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        if (!(world instanceof ISeedReader)) {
            return false;
        }
        Random rand = world.func_201674_k();
        MushroomType mushroomType = this.getType(world, rootPos, species, context.biome());
        int count = (Integer)configuration.get(MAX_COUNT);
        int magnitude = (int)((double)context.radius() * 0.75);
        if (magnitude <= 2) {
            return false;
        }
        ++magnitude;
        for (int i = 0; i < (Integer)configuration.get(MAX_ATTEMPTS); ++i) {
            if (!((double)rand.nextFloat() < (double)((Float)configuration.get(PLACE_CHANCE)).floatValue() * mushroomType.getChanceMult())) continue;
            double angle = (double)rand.nextFloat() * (Math.PI * 2);
            Vector2f offsetVec = new Vector2f((float)((double)magnitude * Math.cos(angle)), (float)((double)magnitude * Math.sin(angle)));
            Vector3i offsetVecInt = new Vector3i(Math.ceil(offsetVec.field_189982_i), 0.0, Math.ceil(offsetVec.field_189983_j));
            BlockPos shroomPos = this.findFloor(species, world, rootPos.func_177971_a(offsetVecInt));
            if (shroomPos == BlockPos.field_177992_a || !SoilHelper.isSoilAcceptable((BlockState)world.func_180495_p(shroomPos), (int)SoilHelper.getSoilFlags((String[])fungusSoils))) continue;
            ConfiguredFeature<?, ?> feature = mushroomType.getFeature(rand, configuration);
            feature.func_242765_a((ISeedReader)world, null, rand, shroomPos);
            if (--count != 0) continue;
            return true;
        }
        return count != (Integer)configuration.get(MAX_COUNT);
    }

    protected MushroomType getType(IWorld world, BlockPos rootPos, Species species, Biome biome) {
        String biomeName = biome.getRegistryName().toString();
        MushroomType type = biomeName.matches(".*glow.*") ? MushroomType.GLOWSHROOM : (biomeName.matches(".*flower.*") ? MushroomType.FLOWER : MushroomType.MUSHROOM);
        return type;
    }

    private static enum MushroomType {
        MUSHROOM(1.0, (r, cf) -> r.nextFloat() < ((Float)cf.get(CHANCE_FOR_MINI)).floatValue() ? (ConfiguredFeature)smallMushrooms.func_226318_b_(r) : (ConfiguredFeature)mushrooms.func_226318_b_(r)),
        GLOWSHROOM(1.0, (r, cf) -> r.nextBoolean() ? (ConfiguredFeature<?, ?>)glowshrooms.func_226318_b_(r) : MUSHROOM.getFeature((Random)r, (GenFeatureConfiguration)cf)),
        FLOWER(0.05, (r, cf) -> (ConfiguredFeature)flowers.func_226318_b_(r));

        double chanceMult;
        BiFunction<Random, GenFeatureConfiguration, ConfiguredFeature<?, ?>> feature;

        private MushroomType(double chanceMult, BiFunction<Random, GenFeatureConfiguration, ConfiguredFeature<?, ?>> feature) {
            this.chanceMult = chanceMult;
            this.feature = feature;
        }

        public double getChanceMult() {
            return this.chanceMult;
        }

        public ConfiguredFeature<?, ?> getFeature(Random random, GenFeatureConfiguration configuration) {
            return this.feature.apply(random, configuration);
        }
    }
}

