/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import org.apache.logging.log4j.LogManager;

public class AlternativeBranchGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> WORLDGEN_PLACE_CHANCE = ConfigurationProperty.floatProperty((String)"worldgen_place_chance");
    public static final ConfigurationProperty<Block> ALT_BRANCH_BLOCK = ConfigurationProperty.block((String)"alternative_branch_block");
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"minimum_radius");

    public AlternativeBranchGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        Block branch = (Block)configuration.get(ALT_BRANCH_BLOCK);
        if (TreeHelper.isBranch((Block)branch) && species.getFamily().isValidBranchBlock((BranchBlock)branch)) {
            return true;
        }
        LogManager.getLogger().warn("Failed to find branch block for the alternative branch feature on species {}", (Object)species);
        return false;
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(ALT_BRANCH_BLOCK, (Object)Blocks.field_150350_a)).with(PLACE_CHANCE, (Object)Float.valueOf(0.02f))).with(WORLDGEN_PLACE_CHANCE, (Object)Float.valueOf(0.1f))).with(MIN_RADIUS, (Object)4)).with(FRUITING_RADIUS, (Object)6);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{ALT_BRANCH_BLOCK, PLACE_CHANCE, WORLDGEN_PLACE_CHANCE, MIN_RADIUS, FRUITING_RADIUS});
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos rootPos;
        IWorld world = context.world();
        BlockState blockState = world.func_180495_p((rootPos = context.pos()).func_177984_a());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS)) {
            this.placeAltBranches(true, configuration, world, rootPos, context.species().getFamily());
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        BlockPos rootPos;
        if (context.fertility() == 0) {
            return false;
        }
        IWorld world = context.world();
        BlockState blockState = world.func_180495_p((rootPos = context.pos()).func_177984_a());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural() && world.func_201674_k().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            this.placeAltBranches(false, configuration, world, rootPos, context.species().getFamily());
        }
        return true;
    }

    private void placeAltBranches(boolean isWorldgen, GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, Family family) {
        WeightedList validSpots = new WeightedList();
        FindValidBranchesNode altBranchPlacer = new FindValidBranchesNode((WeightedList<BlockPos>)validSpots, (Integer)configuration.get(MIN_RADIUS), family);
        TreeHelper.startAnalysisFromRoot((IWorld)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{altBranchPlacer}));
        if (!validSpots.func_234005_b_()) {
            if (isWorldgen) {
                for (BlockPos listPos : validSpots.func_220655_b().collect(Collectors.toSet())) {
                    if (!(world.func_201674_k().nextFloat() < ((Float)configuration.get(WORLDGEN_PLACE_CHANCE)).floatValue())) continue;
                    this.placeBranch(configuration, world, listPos);
                }
            } else {
                this.placeBranch(configuration, world, (BlockPos)validSpots.func_226318_b_(world.func_201674_k()));
            }
        }
    }

    private void placeBranch(GenFeatureConfiguration configuration, IWorld world, BlockPos pos) {
        BranchBlock branchToPlace = (BranchBlock)configuration.get(ALT_BRANCH_BLOCK);
        int radius = TreeHelper.getRadius((IBlockReader)world, (BlockPos)pos);
        branchToPlace.setRadius(world, pos, radius, null);
    }

    public static class FindValidBranchesNode
    implements NodeInspector {
        private final WeightedList<BlockPos> validSpots;
        private final int minRadius;
        private final Family family;

        public FindValidBranchesNode(WeightedList<BlockPos> validSpots, int minRadius, Family family) {
            this.validSpots = validSpots;
            this.minRadius = minRadius;
            this.family = family;
        }

        public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
            boolean valid;
            int radius = TreeHelper.getRadius((IBlockReader)world, (BlockPos)pos);
            boolean bl = valid = radius >= this.minRadius && blockState.func_177230_c() == this.family.getValidBranchBlock(0);
            if (valid) {
                this.validSpots.func_226313_a_((Object)pos, radius);
            }
            return valid;
        }

        public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
            return false;
        }
    }
}

