/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.cells;

import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.cells.ConiferTopBranchCell;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.cells.NormalCell;
import com.ferreusveritas.dynamictrees.cells.PalmFrondCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import maxhyper.dtbyg.DynamicTreesBYG;
import maxhyper.dtbyg.cells.DTBYGLeafClusters;
import maxhyper.dtbyg.cells.cell.BushyBranchCell;
import maxhyper.dtbyg.cells.cell.BushyLeafCell;
import maxhyper.dtbyg.cells.cell.ConiferLeafCell2;
import maxhyper.dtbyg.cells.cell.LamentLeafCell;
import maxhyper.dtbyg.cells.cell.PoplarBranchCell;
import maxhyper.dtbyg.cells.cell.PoplarLeafCell;
import maxhyper.dtbyg.cells.cell.PoplarTopBranchCell;
import maxhyper.dtbyg.cells.cell.SparseBranchCell;
import maxhyper.dtbyg.cells.cell.SythianWartCell;
import maxhyper.dtbyg.cells.cell.WillowBranchCell;
import maxhyper.dtbyg.cells.cell.WillowLeafCell;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class DTBYGCellKits {
    public static final CellKit PALM = new CellKit(new ResourceLocation("dtbyg", "palm")){
        private final Cell palmBranch = new Cell(){

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return side == Direction.UP ? this.getValue() : 0;
            }
        };
        private final Cell[] palmFrondCells = new Cell[]{CellNull.NULL_CELL, new PalmFrondCell(1), new PalmFrondCell(2), new PalmFrondCell(3), new PalmFrondCell(4), new PalmFrondCell(5), new PalmFrondCell(6), new PalmFrondCell(7)};
        private final CellKits.BasicSolver palmSolver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.palmFrondCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 3 ? this.palmBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.PALM;
        }

        public CellSolver getCellSolver() {
            return this.palmSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit SPARSE = new CellKit(new ResourceLocation("dtbyg", "sparse")){
        private final Cell sparseBranch = new SparseBranchCell();
        private final Cell sparseLeaves = new NormalCell(1);
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    public static final CellKit POPLAR = new CellKit(new ResourceLocation("dtbyg", "poplar")){
        private final Cell poplarBranch = new PoplarBranchCell();
        private final Cell poplarTopBranch = new PoplarTopBranchCell();
        private final Cell poplarUpperTrunk = new NormalCell(4);
        private final Cell[] poplarLeaves = new Cell[]{CellNull.NULL_CELL, new PoplarLeafCell(1), new PoplarLeafCell(2), new PoplarLeafCell(3), new PoplarLeafCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1042, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.poplarLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.poplarTopBranch;
            }
            if (radius == 1) {
                return this.poplarBranch;
            }
            if (radius < 4) {
                return this.poplarUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.POPLAR;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit SMALL_DECIDUOUS = new CellKit(new ResourceLocation("dtbyg", "small_deciduous")){
        private final Cell sparseBranch = new NormalCell(4);
        private final Cell sparseLeaves = new NormalCell(1);
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    public static final CellKit WILLOW = new CellKit(DynamicTreesBYG.resLoc("willow")){
        private final Cell branch = new WillowBranchCell();
        private final Cell[] willowLeafCells = new Cell[]{CellNull.NULL_CELL, new WillowLeafCell(1), new WillowLeafCell(2), new WillowLeafCell(3), new WillowLeafCell(4), new WillowLeafCell(5), new WillowLeafCell(6), new WillowLeafCell(7)};
        private final CellKits.BasicSolver solver = new CellKits.BasicSolver(new short[]{2071, 1830, 1573, 1812, 1556, 1300, 1043, 786, 529});

        public Cell getCellForLeaves(int distance) {
            return this.willowLeafCells[distance];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branch : CellNull.NULL_CELL;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.WILLOW;
        }

        public int getDefaultHydration() {
            return 7;
        }
    };
    public static final CellKit ROUND_CONIFER = new CellKit(DynamicTreesBYG.resLoc("round_conifer")){
        private final Cell coniferBranch = new NormalCell(3);
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] coniferLeafCells = new Cell[]{CellNull.NULL_CELL, new ConiferLeafCell2(1), new ConiferLeafCell2(2), new ConiferLeafCell2(3), new ConiferLeafCell2(4), new ConiferLeafCell2(5), new ConiferLeafCell2(6), new ConiferLeafCell2(7)};
        private final CellKits.BasicSolver coniferSolver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.coniferBranch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.ROUND_CONIFER;
        }

        public CellSolver getCellSolver() {
            return this.coniferSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit BUSHY = new CellKit(DynamicTreesBYG.resLoc("bushy")){
        private final Cell branchCell = new BushyBranchCell();
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] coniferLeafCells = new Cell[]{CellNull.NULL_CELL, new BushyLeafCell(1), new BushyLeafCell(2), new BushyLeafCell(3), new BushyLeafCell(4), new BushyLeafCell(5), new BushyLeafCell(6), new BushyLeafCell(7)};
        private final CellKits.BasicSolver solver = new CellKits.BasicSolver(new short[]{1556, 1299, 1059, 802, 1041, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.branchCell;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.BUSHY;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit SYTHIAN_FUNGUS = new CellKit(DynamicTreesBYG.resLoc("sythian_fungus")){
        private final Cell sythianBranch = new SythianWartCell(3);
        private final Cell sythianTopBranch = new SythianWartCell(4);
        private final Cell[] sythianLeafCells = new Cell[]{CellNull.NULL_CELL, new SythianWartCell(1), new SythianWartCell(2), new SythianWartCell(3), new SythianWartCell(4), new SythianWartCell(5), new SythianWartCell(6), new SythianWartCell(7)};
        private final CellKits.BasicSolver sythianSolver = new CellKits.BasicSolver(new short[]{1041, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.sythianLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.sythianTopBranch;
            }
            if (radius == 3) {
                return this.sythianBranch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.SYTHIAN_FUNGUS;
        }

        public CellSolver getCellSolver() {
            return this.sythianSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit LAMENT = new CellKit(DynamicTreesBYG.resLoc("lament")){
        private final Cell lamentBranch = new Cell(){
            final int[] map = new int[]{0, 2, 4, 4, 4, 4};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] lamentLeafCells = new Cell[]{CellNull.NULL_CELL, new LamentLeafCell(1), new LamentLeafCell(2), new LamentLeafCell(3), new LamentLeafCell(4), new LamentLeafCell(5), new LamentLeafCell(6), new LamentLeafCell(7)};
        private final CellKits.BasicSolver lamentSolver = new CellKits.BasicSolver(new short[]{1043, 802, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.lamentLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.lamentBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBYGLeafClusters.LAMENT;
        }

        public CellSolver getCellSolver() {
            return this.lamentSolver;
        }

        public int getDefaultHydration() {
            return 3;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{PALM, SPARSE, POPLAR, SMALL_DECIDUOUS, WILLOW, ROUND_CONIFER, SYTHIAN_FUNGUS, LAMENT});
    }
}

