/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.cancellers;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;

public class CactusFeatureCanceller<T extends Block>
extends FeatureCanceller {
    private static final Random PLACEHOLDER_RAND = new Random();
    private final Class<T> cactusBlockClass;

    public CactusFeatureCanceller(ResourceLocation registryName, Class<T> cactusBlockClass) {
        super(registryName);
        this.cactusBlockClass = cactusBlockClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.FeatureCancellations featureCancellations) {
        IFeatureConfig featureConfig = configuredFeature.field_222738_b;
        if (!(featureConfig instanceof DecoratedFeatureConfig)) {
            return false;
        }
        featureConfig = ((ConfiguredFeature)((DecoratedFeatureConfig)featureConfig).field_214689_a.get()).field_222738_b;
        if (!(featureConfig instanceof DecoratedFeatureConfig)) {
            if (featureConfig instanceof MultipleRandomFeatureConfig) {
                MultipleRandomFeatureConfig config = (MultipleRandomFeatureConfig)featureConfig;
                List list = config.field_202449_a.stream().map(a -> (ConfiguredFeature)a.field_214842_a.get()).distinct().collect(Collectors.toCollection(LinkedList::new));
                list.add(config.field_202452_d.get());
                for (ConfiguredFeature conFeat : list) {
                    if (!(conFeat.field_222738_b instanceof BlockClusterFeatureConfig)) continue;
                    ResourceLocation featureResLoc = conFeat.field_222737_a.getRegistryName();
                    BlockClusterFeatureConfig blockClusterFeatureConfig = (BlockClusterFeatureConfig)conFeat.field_222738_b;
                    BlockStateProvider stateProvider = blockClusterFeatureConfig.field_227289_a_;
                    if (!(stateProvider instanceof SimpleBlockStateProvider)) {
                        return false;
                    }
                    return this.cactusBlockClass.isInstance(stateProvider.func_225574_a_(PLACEHOLDER_RAND, BlockPos.field_177992_a).func_177230_c()) && featureResLoc != null && featureCancellations.shouldCancelNamespace(featureResLoc.func_110624_b());
                }
            } else {
                return false;
            }
        }
        return false;
    }
}

