/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbyg.blocks;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class ScruffyLeavesProperties
extends LeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(ScruffyLeavesProperties::new);
    private float leafChance = 0.5f;
    private int maxHydro = 7;

    public ScruffyLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    public void setLeafChance(float leafChance) {
        this.leafChance = leafChance;
    }

    public void setMaxHydro(int maxHydro) {
        this.maxHydro = maxHydro;
    }

    protected DynamicLeavesBlock createDynamicLeaves(AbstractBlock.Properties properties) {
        return new DynamicLeavesBlock(this, properties){

            public int getHydrationLevelFromNeighbors(IWorld world, BlockPos pos, LeavesProperties leavesProperties) {
                int hash;
                float rand;
                int hydro = super.getHydrationLevelFromNeighbors(world, pos, leavesProperties);
                if (hydro <= ScruffyLeavesProperties.this.maxHydro && (rand = (float)(hash = CoordUtils.coordHashCode((BlockPos)pos, (int)2) % 1000) / 1000.0f) >= ScruffyLeavesProperties.this.leafChance) {
                    return 0;
                }
                return hydro;
            }
        };
    }
}

