/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import vazkii.arl.AutoRegLib;
import vazkii.arl.interf.IDropInItem;
import vazkii.arl.network.message.MessageDropIn;
import vazkii.arl.network.message.MessageDropInCreative;
import vazkii.arl.network.message.MessageSetSelectedItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="autoreglib")
public final class DropInHandler {
    @CapabilityInject(value=IDropInItem.class)
    public static Capability<IDropInItem> DROP_IN_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDropInItem.class, (Capability.IStorage)CapabilityFactory.INSTANCE, (Callable)CapabilityFactory.INSTANCE);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        Screen gui = mc.field_71462_r;
        if (gui instanceof ContainerScreen) {
            ContainerScreen containerGui = (ContainerScreen)gui;
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (!held.func_190926_b()) {
                Container container = containerGui.func_212873_a_();
                Slot under = containerGui.getSlotUnderMouse();
                for (Slot s : container.field_75151_b) {
                    int y;
                    int x;
                    ItemStack stack = s.func_75211_c();
                    IDropInItem dropin = DropInHandler.getDropInHandler(stack);
                    if (dropin == null || !dropin.canDropItemIn((PlayerEntity)mc.field_71439_g, stack, held, s)) continue;
                    if (s == under) {
                        x = event.getMouseX();
                        y = event.getMouseY();
                        int width = gui.field_230708_k_;
                        int height = gui.field_230709_l_;
                        GuiUtils.drawHoveringText((MatrixStack)event.getMatrixStack(), dropin.getDropInTooltip(stack), (int)x, (int)y, (int)width, (int)height, (int)-1, (FontRenderer)mc.field_71466_p);
                        continue;
                    }
                    x = containerGui.getGuiLeft() + s.field_75223_e;
                    y = containerGui.getGuiTop() + s.field_75221_f;
                    RenderSystem.pushMatrix();
                    RenderSystem.disableDepthTest();
                    RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
                    mc.field_71466_p.func_238405_a_(event.getMatrixStack(), "+", (float)(x + 10), (float)(y + 8), 0xFFFF00);
                    RenderSystem.enableDepthTest();
                    RenderSystem.popMatrix();
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRightClick(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        Screen gui = mc.field_71462_r;
        if (gui instanceof ContainerScreen && event.getButton() == 1) {
            ItemStack stack;
            IDropInItem dropin;
            ContainerScreen container = (ContainerScreen)gui;
            Slot under = container.getSlotUnderMouse();
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (under != null && !held.func_190926_b() && under.func_82869_a((PlayerEntity)mc.field_71439_g) && (dropin = DropInHandler.getDropInHandler(stack = under.func_75211_c())) != null) {
                AutoRegLib.network.sendToServer(container instanceof CreativeScreen ? new MessageDropInCreative(under.getSlotIndex(), held) : new MessageDropIn(under.field_75222_d));
                container.field_147007_t = false;
                event.setCanceled(true);
            }
        }
    }

    public static void executeDropIn(PlayerEntity player, int slot) {
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        Slot slotObj = (Slot)container.field_75151_b.get(slot);
        ItemStack target = slotObj.func_75211_c();
        IDropInItem dropin = DropInHandler.getDropInHandler(target);
        ItemStack stack = player.field_71071_by.func_70445_o();
        if (dropin != null && dropin.canDropItemIn(player, target, stack, slotObj)) {
            ItemStack result = dropin.dropItemIn(player, target, stack, slotObj);
            slotObj.func_75215_d(result);
            player.field_71071_by.func_70437_b(stack);
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71137_h = false;
                ((ServerPlayerEntity)player).func_71113_k();
            }
        }
    }

    public static void executeCreativeDropIn(PlayerEntity player, int slot, ItemStack held) {
        if (player == null || !player.func_184812_l_()) {
            return;
        }
        ItemStack target = player.field_71071_by.func_70301_a(slot);
        IDropInItem dropin = DropInHandler.getDropInHandler(target);
        Slot slotObj = (Slot)player.field_71069_bz.field_75151_b.get(slot);
        if (dropin != null && dropin.canDropItemIn(player, target, held, slotObj)) {
            ItemStack result = dropin.dropItemIn(player, target, held, slotObj);
            player.field_71071_by.func_70299_a(slot, result);
            player.field_71071_by.func_70437_b(held);
            if (player instanceof ServerPlayerEntity) {
                AutoRegLib.network.sendToPlayer(new MessageSetSelectedItem(held), (ServerPlayerEntity)player);
            }
        }
    }

    public static IDropInItem getDropInHandler(ItemStack stack) {
        LazyOptional opt = stack.getCapability(DROP_IN_CAPABILITY, null);
        if (opt.isPresent()) {
            return (IDropInItem)opt.orElseGet(() -> new CapabilityFactory.DefaultImpl());
        }
        if (stack.func_77973_b() instanceof IDropInItem) {
            return (IDropInItem)stack.func_77973_b();
        }
        return null;
    }

    private static class CapabilityFactory
    implements Capability.IStorage<IDropInItem>,
    Callable<IDropInItem> {
        private static CapabilityFactory INSTANCE = new CapabilityFactory();

        private CapabilityFactory() {
        }

        public INBT writeNBT(Capability<IDropInItem> capability, IDropInItem instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<IDropInItem> capability, IDropInItem instance, Direction side, INBT nbt) {
        }

        @Override
        public IDropInItem call() {
            return new DefaultImpl();
        }

        private static class DefaultImpl
        implements IDropInItem {
            private DefaultImpl() {
            }

            @Override
            public boolean canDropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming, Slot slotObj) {
                return false;
            }

            @Override
            public ItemStack dropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming, Slot slotObj) {
                return incoming;
            }
        }
    }
}

