/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.entity.LuggageEntity;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class LuggageFollowOwnerGoal
extends Goal {
    private final LuggageEntity luggage;
    private LivingEntity owner;
    private final IWorldReader level;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public LuggageFollowOwnerGoal(LuggageEntity luggage, double speed, float startDist, float stopDist, boolean fly) {
        this.luggage = luggage;
        this.level = luggage.field_70170_p;
        this.speedModifier = speed;
        this.navigation = luggage.func_70661_as();
        this.startDistance = startDist;
        this.stopDistance = stopDist;
        this.canFly = fly;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.luggage.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (this.luggage.tryingToFetchItem) {
            return false;
        }
        if (this.luggage.func_70068_e((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigation.func_75500_f()) {
            return false;
        }
        return !(this.luggage.func_70068_e((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.luggage.func_184643_a(PathNodeType.WATER);
        this.luggage.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigation.func_75499_g();
        this.luggage.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.luggage.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.luggage.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.luggage.func_110167_bD() && !this.luggage.func_184218_aH()) {
                if (this.luggage.func_70068_e((Entity)this.owner) >= 1600.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.func_75497_a((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.luggage.func_70012_b((double)x + 0.5, y, (double)z + 0.5, this.luggage.field_70177_z, this.luggage.field_70125_A);
        this.navigation.func_75499_g();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathNodeType blockpathtypes = WalkNodeProcessor.func_237231_a_((IBlockReader)this.level, (BlockPos.Mutable)pos.func_239590_i_());
        if (blockpathtypes != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.func_180495_p(pos.func_177977_b());
        if (!this.canFly && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vector3i)this.luggage.func_233580_cy_());
        return this.level.func_226665_a__((Entity)this.luggage, this.luggage.func_174813_aQ().func_186670_a(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.luggage.func_70681_au().nextInt(max - min + 1) + min;
    }
}

