/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.Registries;
import com.gizmo.luggage.client.LuggageRenderer;
import com.gizmo.luggage.client.LuggageScreen;
import com.gizmo.luggage.entity.LuggageEntity;
import com.gizmo.luggage.network.CallLuggagePetsPacket;
import com.gizmo.luggage.network.LuggageNetworkHandler;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="luggage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    private static KeyBinding whistleKey;

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registries.EntityRegistry.LUGGAGE.get()), LuggageRenderer::new);
        whistleKey = new KeyBinding("keybind.luggage.whistle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 96, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)ClientEvents.getWhistleKey());
    }

    public static void handlePacket(OpenLuggageScreenPacket message) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityId());
        if (entity instanceof LuggageEntity) {
            LuggageEntity luggage = (LuggageEntity)entity;
            ClientPlayerEntity localplayer = Minecraft.func_71410_x().field_71439_g;
            Inventory simplecontainer = new Inventory(luggage.hasExtendedInventory() ? 54 : 27);
            LuggageMenu menu = new LuggageMenu(message.getContainerId(), localplayer.field_71071_by, (IInventory)simplecontainer, luggage);
            localplayer.field_71070_bA = menu;
            Minecraft.func_71410_x().func_147108_a((Screen)new LuggageScreen(menu, localplayer.field_71071_by, luggage));
        }
    }

    public static KeyBinding getWhistleKey() {
        return whistleKey;
    }

    @Mod.EventBusSubscriber(modid="luggage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void callTheCreatures(InputEvent.KeyInputEvent event) {
            if (ClientEvents.getWhistleKey().func_151468_f() && Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(Registries.SoundRegistry.WHISTLE, 1.0f, 1.0f);
                LuggageNetworkHandler.CHANNEL.sendToServer((Object)new CallLuggagePetsPacket(Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            }
        }
    }
}

