/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.asm.ASMHelper;
import codechicken.asm.CC_ClassWriter;
import codechicken.asm.ObfMapping;
import codechicken.lib.util.CrashLock;
import codechicken.lib.util.SneakyUtils;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.api.MixinFactory;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.forge.ForgeMixinBackend;
import codechicken.mixin.forge.SidedGenerator;
import codechicken.mixin.scala.MixinScalaLanguageSupport;
import codechicken.mixin.util.JavaTraitGenerator;
import codechicken.mixin.util.SimpleDebugger;
import codechicken.mixin.util.Utils;
import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MultiPartGenerator
extends SidedGenerator<TileMultiPart, Factory, TMultiPart> {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final SimpleDebugger.DumpType DEBUG_TYPE = MultiPartGenerator.parseType(System.getProperty("codechicken.multipart.debug", null));
    public static final MultiPartGenerator INSTANCE = new MultiPartGenerator();
    public static final MixinCompiler MIXIN_COMPILER = INSTANCE.getMixinCompiler();
    private final Map<String, MixinFactory.TraitKey> passthroughTraits = new HashMap<String, MixinFactory.TraitKey>();
    private final MixinFactory.TraitKey clientTrait = this.registerTrait(Utils.asmName("codechicken.multipart.trait.TileMultipartClient"));

    private MultiPartGenerator() {
        super(MixinCompiler.create(new ForgeMixinBackend(), MultiPartGenerator.makeDebugger(), MultiPartGenerator.getMixinSupports()), TileMultiPart.class, Factory.class, "cmp");
        Optional javaSupport = this.mixinCompiler.findLanguageSupport("java");
        ((MixinLanguageSupport.JavaMixinLanguageSupport)javaSupport.orElseThrow(() -> new RuntimeException("Unable to find JavaMixinLanguageSupport instance..."))).setTraitGeneratorFactory(MultipartJavaTraitGenerator::new);
    }

    public void registerPassThroughInterface(String iFace) {
        this.registerPassThroughInterface(iFace, true, true);
    }

    public void registerPassThroughInterface(String iFace, boolean client, boolean server) {
        MixinFactory.TraitKey key = this.registerPassthroughTrait(iFace = Utils.asmName(iFace));
        if (key == null) {
            return;
        }
        String tName = key.getTName();
        this.registerTrait(iFace, client ? tName : null, server ? tName : null);
    }

    public void loadAnnotations() {
        LOCK.lock();
        this.loadAnnotations(MultiPartTrait.class, MultiPartTrait.TraitList.class);
    }

    public ImmutableSet<MixinFactory.TraitKey> getTraits(TMultiPart part, boolean client) {
        return this.getTraits(Collections.singleton(part), client);
    }

    public ImmutableSet<MixinFactory.TraitKey> getTraits(Collection<TMultiPart> parts, boolean client) {
        return (ImmutableSet)Streams.concat((Stream[])new Stream[]{client ? Stream.of(this.clientTrait) : Stream.empty(), parts.stream().flatMap(e -> this.getTraitsForObject(e, client).stream())}).collect(ImmutableSet.toImmutableSet());
    }

    public TileMultiPart generateCompositeTile(TileEntity tile, Collection<TMultiPart> parts, boolean client) {
        ImmutableSet<MixinFactory.TraitKey> traits = this.getTraits(parts, client);
        if (tile instanceof TileMultiPart && traits.equals(this.getTraitsForClass(tile.getClass()))) {
            return (TileMultiPart)tile;
        }
        return ((Factory)this.construct(traits)).newInstance();
    }

    public MixinFactory.TraitKey registerPassthroughTrait(String iName) {
        MixinFactory.TraitKey key = this.passthroughTraits.get(iName);
        if (key != null) {
            return key;
        }
        String simpleName = iName.substring(iName.lastIndexOf(47) + 1);
        if (simpleName.startsWith("I") && simpleName.length() > 1 && Character.isUpperCase(simpleName.charAt(1))) {
            simpleName = simpleName.substring(1);
        }
        String tName = "T" + simpleName + "$$PassThrough";
        String vName = "impl";
        String iDesc = "L" + iName + ";";
        ClassNode iNode = this.mixinCompiler.getClassNode(iName);
        if (iNode == null) {
            SneakyUtils.throwUnchecked((Throwable)new ClassNotFoundException("Unable to generate PassThrough trait for interface: " + iName + ", class not found."));
            return null;
        }
        if ((iNode.access & 0x200) == 0) {
            throw new IllegalArgumentException("Class: " + iName + ", is not an interface.");
        }
        CC_ClassWriter cw = new CC_ClassWriter(3);
        cw.visit(52, 32, tName, null, "codechicken/multipart/block/TileMultiPart", new String[]{iName});
        FieldVisitor fv = cw.visitField(2, vName, iDesc, null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultiPart", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv = cw.visitMethod(1, "bindPart", "(Lcodechicken/multipart/api/part/TMultiPart;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultiPart", "bindPart", "(Lcodechicken/multipart/api/part/TMultiPart;)V", false);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(193, iName);
        Label l2 = new Label();
        mv.visitJumpInsn(153, l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, iName);
        mv.visitFieldInsn(181, tName, vName, iDesc);
        mv.visitLabel(l2);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "partRemoved", "(Lcodechicken/multipart/api/part/TMultiPart;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultiPart", "partRemoved", "(Lcodechicken/multipart/api/part/TMultiPart;I)V", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, tName, vName, iDesc);
        l2 = new Label();
        mv.visitJumpInsn(166, l2);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, tName, vName, iDesc);
        mv.visitLabel(l2);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "canAddPart", "(Lcodechicken/multipart/api/part/TMultiPart;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, tName, vName, iDesc);
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(193, iName);
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultiPart", "canAddPart", "(Lcodechicken/multipart/api/part/TMultiPart;)Z", false);
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        this.methods(iNode).forEach(m -> {
            MethodVisitor mv = cw.visitMethod(1, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0]));
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, tName, vName, iDesc);
            Utils.finishBridgeCall(mv, m.desc, 185, iName, m.name, m.desc, true);
        });
        cw.visitEnd();
        this.mixinCompiler.defineInternal(tName, cw.toByteArray());
        key = this.registerTrait(tName);
        this.passthroughTraits.put(iName, key);
        return key;
    }

    private Collection<MethodNode> methods(ClassNode cNode) {
        return this.getAllMethods(new HashSet<String>(), cNode).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)).values();
    }

    private Stream<Pair<String, MethodNode>> getAllMethods(Set<String> visited, ClassNode cNode) {
        Stream<Pair<String, MethodNode>> methods = cNode.methods.stream().map(m -> Pair.of((Object)(m.name + m.desc), (Object)m));
        if (visited.add(cNode.name)) {
            if (!cNode.interfaces.isEmpty()) {
                Stream others = cNode.interfaces.stream().filter(visited::add).map(this.mixinCompiler::getClassNode).flatMap(e -> this.getAllMethods(visited, (ClassNode)e));
                return Streams.concat((Stream[])new Stream[]{methods, others});
            }
            return methods;
        }
        return Stream.empty();
    }

    private static SimpleDebugger.DumpType parseType(String value) {
        if (value == null) {
            return null;
        }
        return SimpleDebugger.DumpType.valueOf(value);
    }

    private static MixinDebugger makeDebugger() {
        if (DEBUG_TYPE == null) {
            return new MixinDebugger.NullDebugger();
        }
        return new SimpleDebugger(Paths.get("./asm/multipart", new String[0]), DEBUG_TYPE);
    }

    @Deprecated
    private static Collection<Class<? extends MixinLanguageSupport>> getMixinSupports() {
        return ImmutableList.of(MixinLanguageSupport.JavaMixinLanguageSupport.class, MixinScalaLanguageSupport.class);
    }

    public static interface Factory {
        public TileMultiPart newInstance();
    }

    private static class MultipartJavaTraitGenerator
    extends JavaTraitGenerator {
        public MultipartJavaTraitGenerator(MixinCompiler mixinCompiler, ClassNode cNode) {
            super(mixinCompiler, cNode);
        }

        @Override
        protected void preCheckNode() {
            if ((this.cNode.access & 0x200) != 0) {
                throw new IllegalArgumentException("Cannot register java interface '" + this.cNode.name + "' as a mixin trait. Try as a PassthroughInterface.");
            }
        }

        @Override
        protected void beforeTransform() {
            ObfMapping m_copyFrom = new ObfMapping(this.cNode.name, "copyFrom", "(Lcodechicken/multipart/block/TileMultiPart;)V");
            if (!this.instanceFields.isEmpty() && ASMHelper.findMethod(m_copyFrom, this.cNode) == null) {
                MethodVisitor mv = m_copyFrom.visitMethod((ClassVisitor)this.cNode, 1, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, "codechicken/multipart/block/TileMultiPart", m_copyFrom.s_name, m_copyFrom.s_desc, false);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(193, this.cNode.name);
                Label end = new Label();
                mv.visitJumpInsn(153, end);
                this.instanceFields.forEach(f -> {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 1);
                    mv.visitFieldInsn(180, this.cNode.name, f.name, f.desc);
                    mv.visitFieldInsn(181, this.cNode.name, f.name, f.desc);
                });
                mv.visitLabel(end);
                mv.visitInsn(177);
                mv.visitMaxs(-1, -1);
                mv.visitEnd();
            }
        }
    }
}

