/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.forge;

import codechicken.mixin.MixinFactoryImpl;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinFactory;
import codechicken.mixin.forge.TraitSide;
import codechicken.mixin.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class SidedGenerator<B, F, T>
extends MixinFactoryImpl<B, F> {
    private static final Logger logger = LogManager.getLogger();
    protected final Map<String, MixinFactory.TraitKey> clientTraits = new HashMap<String, MixinFactory.TraitKey>();
    protected final Map<String, MixinFactory.TraitKey> serverTraits = new HashMap<String, MixinFactory.TraitKey>();
    protected final Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> clientObjectTraitCache = new HashMap();
    protected final Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> serverObjectTraitCache = new HashMap();

    protected SidedGenerator(MixinCompiler mixinCompiler, Class<B> baseType, Class<F> factoryClass, String classSuffix) {
        super(mixinCompiler, baseType, factoryClass, classSuffix);
    }

    public void registerTrait(String marker, String trait) {
        this.registerTrait(marker, trait, trait);
    }

    public void registerTrait(String marker, String clientTrait, String serverTrait) {
        marker = Utils.asmName(marker);
        if (clientTrait != null) {
            this.registerSide(this.clientTraits, marker, Utils.asmName(clientTrait));
        }
        if (serverTrait != null) {
            this.registerSide(this.serverTraits, marker, Utils.asmName(serverTrait));
        }
    }

    public ImmutableSet<MixinFactory.TraitKey> getTraitsForObject(T thing, boolean client) {
        return this.getObjectTraitCache(client).computeIfAbsent(thing.getClass(), clazz -> {
            Map<String, MixinFactory.TraitKey> traits = this.getTraitMap(client);
            return (ImmutableSet)this.hierarchy((Class<?>)clazz).map(Utils::asmName).map(traits::get).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        });
    }

    protected void loadAnnotations(Class<? extends Annotation> aClass, Class<? extends Annotation> aListClass) {
        Type aType = Type.getType(aClass);
        Type lType = Type.getType(aListClass);
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> a.getAnnotationType().equals((Object)aType) || a.getAnnotationType().equals((Object)lType)).filter(a -> a.getTargetType() == ElementType.TYPE).map(a -> {
            if (a.getAnnotationType().equals((Object)lType)) {
                List entries = (List)a.getAnnotationData().get("value");
                return Pair.of((Object)a, (Object)entries);
            }
            return Pair.of((Object)a, Collections.singletonList(a.getAnnotationData()));
        }).forEach(p -> {
            ModFileScanData.AnnotationData a = (ModFileScanData.AnnotationData)p.getLeft();
            List dataList = (List)p.getRight();
            String tName = a.getClassType().getInternalName();
            logger.info("Trait: {}", (Object)tName);
            for (Map data : dataList) {
                Type marker = (Type)data.get("value");
                ModAnnotation.EnumHolder holder = (ModAnnotation.EnumHolder)data.get("side");
                TraitSide side = holder != null ? TraitSide.valueOf(holder.getValue()) : TraitSide.COMMON;
                logger.info("    Marker: {}, Side: {}", (Object)marker.getInternalName(), (Object)side);
                if (!side.isSupported()) continue;
                if (side.isCommon() || side.isClient()) {
                    this.registerSide(this.clientTraits, marker.getInternalName(), tName);
                }
                if (!side.isCommon() && !side.isServer()) continue;
                this.registerSide(this.serverTraits, marker.getInternalName(), tName);
            }
        });
    }

    protected Stream<Class<?>> hierarchy(Class<?> clazz) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(clazz), Arrays.stream(clazz.getInterfaces()).flatMap(this::hierarchy), Streams.stream(Optional.ofNullable(clazz.getSuperclass())).flatMap(this::hierarchy)});
    }

    protected Map<String, MixinFactory.TraitKey> getTraitMap(boolean client) {
        return client ? this.clientTraits : this.serverTraits;
    }

    protected Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> getObjectTraitCache(boolean client) {
        return client ? this.clientObjectTraitCache : this.serverObjectTraitCache;
    }

    protected void registerSide(Map<String, MixinFactory.TraitKey> map, String marker, String trait) {
        MixinFactory.TraitKey existing = map.get(marker);
        MixinFactory.TraitKey newTrait = this.registerTrait(trait);
        if (existing != null) {
            if (!existing.equals(newTrait)) {
                logger.error("Attempted to re-register trait for '{}', with a different impl, Ignoring. Existing: '{}', New: '{}'", (Object)marker, (Object)existing.getTName(), (Object)newTrait.getTName());
                return;
            }
            if (existing.equals(newTrait)) {
                logger.debug("Skipping re-register of trait for '{}', same impl detected.", (Object)marker);
                return;
            }
        }
        map.put(marker, newTrait);
    }
}

