/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.transformers;

import codechicken.asm.ASMBlock;
import codechicken.asm.InsnComparator;
import codechicken.asm.InsnListSection;
import codechicken.asm.ModularASMTransformer;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.MethodTransformer;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class MethodInjector
extends MethodTransformer {
    private static final Logger logger = LogManager.getLogger();
    @Nullable
    public ASMBlock needle;
    @Nonnull
    public ASMBlock injection;
    public boolean before;

    public MethodInjector(@Nonnull ObfMapping method, @Nullable ASMBlock needle, @Nonnull ASMBlock injection, boolean before) {
        super(method);
        this.needle = needle;
        this.injection = injection;
        this.before = before;
    }

    public MethodInjector(@Nonnull ObfMapping method, @Nonnull ASMBlock injection, boolean before) {
        this(method, null, injection, before);
    }

    public MethodInjector(@Nonnull ObfMapping method, @Nonnull InsnList needle, @Nonnull InsnList injection, boolean before) {
        this(method, new ASMBlock(needle), new ASMBlock(injection), before);
    }

    public MethodInjector(@Nonnull ObfMapping method, @Nonnull InsnList injection, boolean before) {
        this(method, null, new ASMBlock(injection), before);
    }

    @Override
    public void addMethodsToSort(Set<ObfMapping> set) {
        set.add(this.method);
    }

    @Override
    public void transform(MethodNode mv) {
        if (this.needle == null) {
            logger.log(ModularASMTransformer.LEVEL, "Injecting {} method '{}'", (Object)(this.before ? "before" : "after"), (Object)this.method);
            if (this.before) {
                mv.instructions.insert(this.injection.rawListCopy());
            } else {
                mv.instructions.add(this.injection.rawListCopy());
            }
        } else {
            for (InsnListSection key : InsnComparator.findN(mv.instructions, this.needle.list)) {
                logger.log(ModularASMTransformer.LEVEL, "Injecting {} method '{}' @ {} - {}", (Object)(this.before ? "before" : "after"), (Object)this.method, (Object)key.start, (Object)key.end);
                ASMBlock injectBlock = this.injection.copy().mergeLabels(this.needle.applyLabels(key));
                if (this.before) {
                    key.insertBefore(injectBlock.list.list);
                    continue;
                }
                key.insert(injectBlock.list.list);
            }
        }
    }
}

