/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import mod.lucky.common.GameAPI;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.attribute.ParserKt;
import mod.lucky.common.drop.WeightedDrop;
import mod.lucky.common.drop.WeightedDropKt;
import mod.lucky.java.Addon;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.JavaLuckyRegistry;
import mod.lucky.java.loader.AddonResources;
import mod.lucky.java.loader.GlobalSettings;
import mod.lucky.java.loader.LocalSettings;
import mod.lucky.java.loader.MainResources;
import mod.lucky.java.loader.ReadCraftingKt;
import mod.lucky.java.loader.ReadSettingsKt;
import mod.lucky.java.loader.ReadStructuresKt;
import mod.lucky.java.loader.ReadWorldGenDropsKt;
import mod.lucky.java.loader.StructureResource;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.ArraysKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.io.FilesKt;
import mod.lucky.kotlin.jvm.functions.Function0;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.sequences.SequencesKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\n\u001a\u00020\b\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\b\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00010\u00162\u0006\u0010\n\u001a\u00020\b\u001a\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001b\u001a\u00020\r\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001c"}, d2={"commonConfigFiles", "", "", "getCommonConfigFiles", "()Ljava/util/List;", "extractDefaultConfig", "", "configDir", "Ljava/io/File;", "findAddonsOrMakeDir", "gameDir", "getConfigDir", "getInputStream", "Ljava/io/InputStream;", "baseDir", "path", "loadAddonResources", "Lmod/lucky/java/loader/AddonResources;", "addonFile", "loadMainResources", "Lmod/lucky/java/loader/MainResources;", "loadResources", "Lmod/lucky/kotlin/Pair;", "parseDrops", "Lmod/lucky/common/drop/WeightedDrop;", "lines", "readLines", "stream", "common"})
public final class LoaderKt {
    @NotNull
    private static final List<String> commonConfigFiles;

    @NotNull
    public static final List<String> getCommonConfigFiles() {
        return commonConfigFiles;
    }

    @Nullable
    public static final InputStream getInputStream(@NotNull File baseDir, @NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter(baseDir, "baseDir");
        Intrinsics.checkNotNullParameter(path, "path");
        if (baseDir.isDirectory()) {
            File file = new File(baseDir + '/' + path);
            inputStream = file.exists() && !file.isDirectory() ? new FileInputStream(file) : null;
        } else {
            Object v1;
            ZipFile file;
            block3: {
                file = new ZipFile(baseDir);
                Object object = file.entries();
                Intrinsics.checkNotNullExpressionValue(object, "file.entries()");
                boolean bl = false;
                object = SequencesKt.asSequence(CollectionsKt.iterator(object));
                bl = false;
                Object object2 = object;
                boolean bl2 = false;
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    ZipEntry it = (ZipEntry)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getName(), path)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            ZipEntry entry = v1;
            inputStream = entry != null && !entry.isDirectory() ? file.getInputStream(entry) : null;
        }
        return inputStream;
    }

    @NotNull
    public static final List<String> readLines(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
        return SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(bufferedReader){
            final /* synthetic */ BufferedReader $bufferedReader;
            {
                this.$bufferedReader = $bufferedReader;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$bufferedReader.readLine();
            }
        }));
    }

    @NotNull
    public static final File getConfigDir(@NotNull File gameDir) {
        Intrinsics.checkNotNullParameter(gameDir, "gameDir");
        return FilesKt.resolve(gameDir, "config/lucky/" + JavaGameAPIKt.getJavaGameAPI().getModVersion() + '-' + JavaGameAPIKt.getJavaGameAPI().getLoaderName());
    }

    @NotNull
    public static final List<WeightedDrop> parseDrops(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        List<String> newLines = ParserKt.splitLines(lines);
        return WeightedDropKt.dropsFromStrList(newLines);
    }

    public static final void extractDefaultConfig(@NotNull File configDir) {
        Intrinsics.checkNotNullParameter(configDir, "configDir");
        try {
            InputStream stream = JavaLuckyRegistry.class.getResourceAsStream("lucky-config.zip");
            if (stream == null) {
                GameAPIKt.getGameAPI().logInfo("No default resources found. Ignore this in a dev environment.");
                return;
            }
            ZipInputStream inputStream = new ZipInputStream(stream);
            Iterator iterator2 = SequencesKt.generateSequence((Function0)new Function0<ZipEntry>(inputStream){
                final /* synthetic */ ZipInputStream $inputStream;
                {
                    this.$inputStream = $inputStream;
                    super(0);
                }

                @Nullable
                public final ZipEntry invoke() {
                    return this.$inputStream.getNextEntry();
                }
            }).iterator();
            while (iterator2.hasNext()) {
                ZipEntry entry = (ZipEntry)iterator2.next();
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string, "entry.name");
                File dest = FilesKt.resolve(configDir, string);
                if (entry.isDirectory() || dest.exists()) continue;
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                dest.createNewFile();
                FileOutputStream outputStream = new FileOutputStream(dest);
                Iterator iterator3 = SequencesKt.generateSequence((Function0)new Function0<Integer>(inputStream){
                    final /* synthetic */ ZipInputStream $inputStream;
                    {
                        this.$inputStream = $inputStream;
                        super(0);
                    }

                    @Nullable
                    public final Integer invoke() {
                        int n = this.$inputStream.read();
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = n;
                        boolean bl3 = false;
                        return it == -1 ? null : Integer.valueOf(it);
                    }
                }).iterator();
                while (iterator3.hasNext()) {
                    int dataByte = ((Number)iterator3.next()).intValue();
                    outputStream.write(dataByte);
                }
                outputStream.close();
            }
            inputStream.close();
        }
        catch (Exception e) {
            GameAPIKt.getGameAPI().logError("Error extracting default config", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MainResources loadMainResources(@NotNull File configDir) {
        void $this$mapValuesTo$iv$iv;
        Pair<Object, List<String>> pair;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configDir, "configDir");
        Iterable $this$map$iv = commonConfigFiles;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair<void, List<String>> pair2;
            void path;
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            InputStream stream = LoaderKt.getInputStream(configDir, (String)path);
            if (stream == null) {
                GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), "Missing resource '" + (String)path + "' in " + configDir.getPath(), null, 2, null);
                pair2 = TuplesKt.to(path, CollectionsKt.emptyList());
            } else {
                pair2 = TuplesKt.to(path, LoaderKt.readLines(stream));
            }
            pair = pair2;
            object.add(pair);
        }
        Map fileContents = MapsKt.toMap((List)destination$iv$iv);
        Pair[] $i$f$map22 = new Pair[]{TuplesKt.to("lucky:lucky_block", "drops.txt"), TuplesKt.to("lucky:lucky_sword", "sword_drops.txt"), TuplesKt.to("lucky:lucky_bow", "bow_drops.txt"), TuplesKt.to("lucky:lucky_potion", "potion_drops.txt")};
        Map $this$mapValues$iv = MapsKt.mapOf($i$f$map22);
        boolean $i$f$mapValues = false;
        destination$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List<WeightedDrop> list;
            void $dstr$_u24__u24$v;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            pair = k;
            object = map;
            boolean bl2 = false;
            List<WeightedDrop> list2 = $dstr$_u24__u24$v;
            boolean bl3 = false;
            String v = (String)list2.getValue();
            List list3 = (List)fileContents.get(v);
            if (list3 == null) {
                list = null;
            } else {
                List list4 = list3;
                boolean bl4 = false;
                boolean bl5 = false;
                List it = list4;
                boolean bl6 = false;
                list = LoaderKt.parseDrops(it);
            }
            list2 = list;
            List list5 = list2 == null ? CollectionsKt.emptyList() : list2;
            object.put(pair, list5);
        }
        Map drops = destination$iv$iv2;
        Object object2 = (List)fileContents.get("properties.txt");
        Intrinsics.checkNotNull(object2);
        GlobalSettings globalSettings = ReadSettingsKt.parseGlobalSettings((List<String>)object2);
        Object object3 = (List)fileContents.get("properties.txt");
        Intrinsics.checkNotNull(object3);
        object2 = ReadSettingsKt.parseLocalSettings((List<String>)object3);
        Object object4 = (List)fileContents.get("natural_gen.txt");
        Intrinsics.checkNotNull(object4);
        object3 = ReadWorldGenDropsKt.readWorldGenDrops((List<String>)object4);
        Object object5 = (List)fileContents.get("luck_crafting.txt");
        Intrinsics.checkNotNull(object5);
        object4 = ReadCraftingKt.readCraftingLuckModifiers((List<String>)object5);
        List list = (List)fileContents.get("structures.txt");
        Intrinsics.checkNotNull(list);
        object5 = ReadStructuresKt.readStructures(configDir, list);
        return new MainResources(globalSettings, (LocalSettings)object2, drops, (Map<String, ? extends List<WeightedDrop>>)object3, (Map<String, ? extends StructureResource>)object5, (Map<String, Integer>)object4);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Nullable
    public static final AddonResources loadAddonResources(@NotNull File addonFile) {
        Intrinsics.checkNotNullParameter(addonFile, "addonFile");
        var2_1 = new String[]{"plugin_init.txt", "recipes.txt"};
        configFiles = CollectionsKt.plus((Collection)LoaderKt.commonConfigFiles, (Iterable)CollectionsKt.listOf(var2_1));
        $this$map$iv = configFiles;
        $i$f$map = false;
        var5_6 = $this$map$iv;
        destination$iv$iv = (Pair[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var10_29 = (String)item$iv$iv;
            var23_39 = destination$iv$iv;
            $i$a$-map-LoaderKt$loadAddonResources$fileContents$1 = false;
            stream = LoaderKt.getInputStream(addonFile, (String)path);
            if (stream == null) {
                if (Intrinsics.areEqual(path, "plugin_init.txt")) {
                    GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), "Missing resource '" + (String)path + "' for addon '" + addonFile.getName() + '\'', null, 2, null);
                    return null;
                }
                v0 /* !! */  = TuplesKt.to(path, CollectionsKt.emptyList());
            } else {
                v0 /* !! */  = TuplesKt.to(path, LoaderKt.readLines(stream));
            }
            var24_40 = v0 /* !! */ ;
            var23_39.add(var24_40);
        }
        fileContents = MapsKt.toMap((List)destination$iv$iv);
        $i$f$map = (List)fileContents.get("plugin_init.txt");
        Intrinsics.checkNotNull($i$f$map);
        addonIds = ReadSettingsKt.readAddonIds($i$f$map);
        v1 = $this$mapTo$iv$iv = new Pair[4];
        v2 = 0;
        destination$iv$iv = addonIds.getBlock();
        if (destination$iv$iv == null) {
            v3 = null;
        } else {
            $i$f$mapTo = destination$iv$iv;
            var8_17 = false;
            item$iv$iv = false;
            path = $i$f$mapTo;
            var24_41 = v2;
            var23_39 = v1;
            $i$a$-let-LoaderKt$loadAddonResources$drops$1 = false;
            var25_46 = TuplesKt.to(it, "drops.txt");
            v1 = var23_39;
            v2 = var24_41;
            v3 = var25_46;
        }
        v1[v2] = v3;
        v4 = $this$mapTo$iv$iv;
        v5 = 1;
        destination$iv$iv = addonIds.getSword();
        if (destination$iv$iv == null) {
            v6 /* !! */  = null;
        } else {
            $i$f$mapTo = destination$iv$iv;
            var8_18 = false;
            item$iv$iv = false;
            it = $i$f$mapTo;
            var24_42 = v5;
            var23_39 = v4;
            $i$a$-let-LoaderKt$loadAddonResources$drops$2 = false;
            var25_46 = TuplesKt.to(it, "sword_drops.txt");
            v4 = var23_39;
            v5 = var24_42;
            v6 /* !! */  = var25_46;
        }
        v4[v5] = v6 /* !! */ ;
        v7 = $this$mapTo$iv$iv;
        v8 = 2;
        destination$iv$iv = addonIds.getBow();
        if (destination$iv$iv == null) {
            v9 /* !! */  = null;
        } else {
            $i$f$mapTo = destination$iv$iv;
            var8_19 = false;
            item$iv$iv = false;
            it = $i$f$mapTo;
            var24_43 = v8;
            var23_39 = v7;
            $i$a$-let-LoaderKt$loadAddonResources$drops$3 = false;
            var25_46 = TuplesKt.to(it, "bow_drops.txt");
            v7 = var23_39;
            v8 = var24_43;
            v9 /* !! */  = var25_46;
        }
        v7[v8] = v9 /* !! */ ;
        v10 = $this$mapTo$iv$iv;
        v11 = 3;
        destination$iv$iv = addonIds.getPotion();
        if (destination$iv$iv == null) {
            v12 /* !! */  = null;
        } else {
            $i$f$mapTo = destination$iv$iv;
            var8_20 = false;
            item$iv$iv = false;
            it = $i$f$mapTo;
            var24_44 = v11;
            var23_39 = v10;
            $i$a$-let-LoaderKt$loadAddonResources$drops$4 = false;
            var25_46 = TuplesKt.to(it, "potion_drops.txt");
            v10 = var23_39;
            v11 = var24_44;
            v12 /* !! */  = var25_46;
        }
        v10[v11] = v12 /* !! */ ;
        $this$mapValues$iv = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull($this$mapTo$iv$iv));
        $i$f$mapValues = false;
        $i$f$mapTo = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (E element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            var14_48 = (Map.Entry)element$iv$iv$iv;
            var15_49 = destination$iv$iv;
            $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
            var17_51 = it$iv$iv.getKey();
            var18_52 = (Map.Entry)element$iv$iv$iv;
            var24_45 = var17_51;
            var23_39 = var15_49;
            $i$a$-mapValues-LoaderKt$loadAddonResources$drops$5 = false;
            var20_54 = $dstr$_u24__u24$v;
            var21_55 = false;
            v = (String)var20_54.getValue();
            var20_54 = (List)fileContents.get(v);
            Intrinsics.checkNotNull(var20_54);
            var25_46 = LoaderKt.parseDrops(var20_54);
            var23_39.put(var24_45, var25_46);
        }
        drops = destination$iv$iv;
        var6_9 = new String[]{addonIds.getBlock(), addonIds.getSword(), addonIds.getBow(), addonIds.getPotion()};
        addonId = CollectionsKt.first(CollectionsKt.listOfNotNull(var6_9));
        v13 = new Addon(addonIds, addonFile, addonId);
        var6_9 = (List)fileContents.get("properties.txt");
        Intrinsics.checkNotNull(var6_9);
        v14 = ReadSettingsKt.parseLocalSettings((List<String>)var6_9);
        v15 = drops;
        var6_9 = (List)fileContents.get("structures.txt");
        v16 = ReadStructuresKt.readStructures(addonFile, (List<String>)(var6_9 == null ? CollectionsKt.emptyList() : var6_9));
        var7_15 = (List)fileContents.get("natural_gen.txt");
        if (var7_15 == null) {
            v17 /* !! */  = null;
        } else {
            var8_16 = var7_15;
            var9_27 = false;
            var10_30 = false;
            $i$f$associateByTo = var8_16;
            var28_57 = v16;
            var27_58 = v15;
            var26_59 = v14;
            var25_46 = v13;
            $i$a$-let-LoaderKt$loadAddonResources$1 = false;
            var29_60 /* !! */  = ReadWorldGenDropsKt.readWorldGenDrops((List<String>)it);
            v13 = var25_46;
            v14 = var26_59;
            v15 = var27_58;
            v16 = var28_57;
            v17 /* !! */  = var29_60 /* !! */ ;
        }
        var6_9 = v17 /* !! */ ;
        v18 /* !! */  = var6_9 == null ? MapsKt.emptyMap() : var6_9;
        var7_15 = (List)fileContents.get("luck_crafting.txt");
        if (var7_15 == null) {
            v19 = null;
        } else {
            var8_16 = var7_15;
            var9_27 = false;
            var10_31 = false;
            it = var8_16;
            var29_60 /* !! */  = v18 /* !! */ ;
            var28_57 = v16;
            var27_58 = v15;
            var26_59 = v14;
            var25_46 = v13;
            $i$a$-let-LoaderKt$loadAddonResources$2 = false;
            var30_61 = ReadCraftingKt.readCraftingLuckModifiers((List<String>)it);
            v13 = var25_46;
            v14 = var26_59;
            v15 = var27_58;
            v16 = var28_57;
            v18 /* !! */  = var29_60 /* !! */ ;
            v19 = var30_61;
        }
        var6_9 = v19;
        v20 /* !! */  = var6_9 == null ? MapsKt.emptyMap() : var6_9;
        if (addonIds.getBlock() == null) ** GOTO lbl-1000
        var6_9 = fileContents;
        var7_15 = "recipes.txt";
        var8_21 = false;
        var9_28 = var6_9;
        var10_32 = false;
        if (var9_28.containsKey(var7_15)) {
            var6_9 = (List)fileContents.get("recipes.txt");
            Intrinsics.checkNotNull(var6_9);
            v21 /* !! */  = ReadCraftingKt.readAddonCraftingRecipes((List<String>)var6_9, addonIds.getBlock());
        } else lbl-1000:
        // 2 sources

        {
            v21 /* !! */  = CollectionsKt.emptyList();
        }
        var31_62 = v21 /* !! */ ;
        var32_63 /* !! */  = v20 /* !! */ ;
        var33_64 /* !! */  = v18 /* !! */ ;
        var34_65 = v16;
        var35_66 = v15;
        var36_67 = v14;
        var37_68 = v13;
        return new AddonResources((Addon)var37_68, var36_67, var35_66, var34_65, (Map<String, ? extends List<WeightedDrop>>)var33_64 /* !! */ , (Map<String, Integer>)var32_63 /* !! */ , var31_62);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<File> findAddonsOrMakeDir(@NotNull File gameDir) {
        block8: {
            block9: {
                block7: {
                    Intrinsics.checkNotNullParameter(gameDir, "gameDir");
                    addonsDirV1 = FilesKt.resolve(gameDir, "addons/luckyBlock");
                    addonsDirV2 = FilesKt.resolve(gameDir, "addons/lucky");
                    if (addonsDirV2.exists()) {
                        v0 = addonsDirV2;
                    } else if (addonsDirV1.exists()) {
                        v0 = addonsDirV1;
                    } else {
                        addonsDirV2.mkdirs();
                        return CollectionsKt.emptyList();
                    }
                    addonsDir = v0;
                    var5_4 = addonsDir.listFiles();
                    if (var5_4 != null) break block7;
                    v1 = null;
                    break block8;
                }
                var6_5 = ArraysKt.toList(var5_4);
                if (var6_5 != null) break block9;
                v1 = null;
                break block8;
            }
            $this$filter$iv = var6_5;
            $i$f$filter = false;
            var9_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                $i$a$-filter-LoaderKt$findAddonsOrMakeDir$1 = false;
                if (it.isDirectory()) ** GOTO lbl-1000
                var16_15 = new String[]{"zip", "jar"};
                v2 = CollectionsKt.listOf(var16_15);
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (v2.contains(FilesKt.getExtension(it))) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (!v3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v1 = (List)destination$iv$iv;
        }
        var4_16 = v1;
        return var4_16 == null ? CollectionsKt.emptyList() : var4_16;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<MainResources, List<AddonResources>> loadResources(@NotNull File gameDir) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(gameDir, "gameDir");
        File configDir = LoaderKt.getConfigDir(gameDir);
        LoaderKt.extractDefaultConfig(configDir);
        MainResources mainResources = LoaderKt.loadMainResources(configDir);
        Iterable $this$mapNotNull$iv = LoaderKt.findAddonsOrMakeDir(gameDir);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AddonResources addonResources;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (LoaderKt.loadAddonResources(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AddonResources it$iv$iv = addonResources;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allAddonResources = (List)destination$iv$iv;
        return new Pair<MainResources, List<AddonResources>>(mainResources, allAddonResources);
    }

    static {
        String[] stringArray = new String[]{"drops.txt", "sword_drops.txt", "bow_drops.txt", "potion_drops.txt", "natural_gen.txt", "properties.txt", "structures.txt", "luck_crafting.txt"};
        commonConfigFiles = CollectionsKt.listOf(stringArray);
    }
}

