/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.forge.game;

import com.mojang.serialization.Codec;
import java.util.Random;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.Vec3;
import mod.lucky.forge.game.LuckyWorldFeatureKt;
import mod.lucky.java.game.LuckyWorldGenUtilsKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.jvm.internal.DefaultConstructorMarker;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.ranges.RangesKt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmod/lucky/forge/game/LuckyWorldFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lnet/minecraft/world/gen/feature/NoFeatureConfig;", "codec", "Lcom/mojang/serialization/Codec;", "blockId", "", "(Lcom/mojang/serialization/Codec;Ljava/lang/String;)V", "place", "", "world", "Lnet/minecraft/world/ISeedReader;", "chunkGenerator", "Lnet/minecraft/world/gen/ChunkGenerator;", "random", "Ljava/util/Random;", "pos", "Lnet/minecraft/util/math/BlockPos;", "config", "luckyblock"})
public final class LuckyWorldFeature
extends Feature<NoFeatureConfig> {
    @NotNull
    private final String blockId;

    public LuckyWorldFeature(@NotNull Codec<NoFeatureConfig> codec, @NotNull String blockId) {
        Intrinsics.checkNotNullParameter(codec, "codec");
        Intrinsics.checkNotNullParameter(blockId, "blockId");
        super(codec);
        this.blockId = blockId;
    }

    public /* synthetic */ LuckyWorldFeature(Codec codec, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "lucky:lucky_block";
        }
        this((Codec<NoFeatureConfig>)codec, string);
    }

    public boolean place(@NotNull ISeedReader world, @NotNull ChunkGenerator chunkGenerator, @NotNull Random random, @NotNull BlockPos pos, @NotNull NoFeatureConfig config) {
        boolean bl;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(chunkGenerator, "chunkGenerator");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            Object v0;
            BlockPos topPos;
            block4: {
                topPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos);
                Iterable $this$firstOrNull$iv = RangesKt.downTo(topPos.func_177956_o(), 1);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!LuckyWorldFeatureKt.access$canGenerateAt(world, new BlockPos(topPos.func_177958_n(), it, topPos.func_177952_p()))) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Integer surfaceY = v0;
            if (surfaceY != null) {
                Vec3<Number> vec3 = new Vec3<Number>(topPos.func_177958_n(), surfaceY, topPos.func_177952_p());
                String string = world.func_201672_e().func_234923_W_().func_240901_a_().toString();
                Intrinsics.checkNotNullExpressionValue(string, "world.level.dimension().location().toString()");
                LuckyWorldGenUtilsKt.generateLuckyFeature(world, vec3, this.blockId, string, random);
            }
            bl = false;
        }
        catch (Exception e) {
            GameAPIKt.getGameAPI().logError("Error during natural generation", e);
            bl = false;
        }
        return bl;
    }
}

