/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.forge;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mod.lucky.common.GameAPI;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.ListAttr;
import mod.lucky.common.attribute.ValueAttr;
import mod.lucky.forge.ForgeGameAPIKt;
import mod.lucky.forge.ForgeJavaGameAPIKt;
import mod.lucky.forge.ForgeLuckyRegistry;
import mod.lucky.forge.OnlyInClient;
import mod.lucky.java.Enchantment;
import mod.lucky.java.EnchantmentType;
import mod.lucky.java.JavaGameAPI;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.StatusEffect;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.NoWhenBranchMatchedException;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.ArraysKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.DefaultConstructorMarker;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.ItemIntIDToString;
import net.minecraft.util.datafix.fixes.ItemStackDataFlattening;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.versions.mcp.MCPVersion;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J$\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J.\u0010\u0013\u001a\u00020\u00142\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u00112\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016JX\u0010\u0019\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001b0\u0016j\u0002`\u001c\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001b0\u0016j\u0002`\u001c0\u001a2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u00112\n\u0010\u001d\u001a\u00060\u000ej\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0016\u0010\"\u001a\u0004\u0018\u00010\t2\n\u0010#\u001a\u00060\u000ej\u0002`$H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0&H\u0016J\u0014\u0010*\u001a\u00020\t2\n\u0010+\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0014\u0010,\u001a\u00020\t2\n\u0010+\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u001e\u0010-\u001a\f\u0012\u0004\u0012\u00020\u001b0\u0016j\u0002`\u001c2\n\u0010+\u001a\u00060\u000ej\u0002`\u000fH\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0016\u00100\u001a\u0004\u0018\u00010\t2\n\u00101\u001a\u00060\u000ej\u0002`2H\u0016J\b\u00103\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020\tH\u0016J\b\u00105\u001a\u00020\tH\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\n\u001a\u00020\tH\u0016J\u0014\u00109\u001a\u00020:2\n\u0010\u001d\u001a\u00060\u000ej\u0002`\u001eH\u0016J\u0014\u0010;\u001a\u00020:2\n\u0010\u001d\u001a\u00060\u000ej\u0002`\u001eH\u0016J\u0010\u0010<\u001a\u00020:2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0014\u0010=\u001a\u00020\u00072\n\u0010>\u001a\u00060\u000ej\u0002`?H\u0016J\u0010\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020BH\u0016J$\u0010C\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`?2\n\u0010>\u001a\u00060\u000ej\u0002`?2\u0006\u0010D\u001a\u00020\tH\u0016J*\u0010E\u001a\u001c\u0012\b\u0012\u00060\u000ej\u0002`F\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\u0016j\u0002`\u00170\u001a2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\tH\u0017J(\u0010J\u001a\u00020H2\n\u0010>\u001a\u00060\u000ej\u0002`?2\u0006\u0010D\u001a\u00020\t2\n\u0010K\u001a\u00060\u000ej\u0002`?H\u0016\u00a8\u0006L"}, d2={"Lmod/lucky/forge/ForgeJavaGameAPI;", "Lmod/lucky/java/JavaGameAPI;", "()V", "attrToNBT", "Lnet/minecraft/nbt/INBT;", "Lmod/lucky/forge/Tag;", "attr", "Lmod/lucky/common/attribute/Attr;", "convertLegacyItemId", "", "id", "", "data", "findEntityByUUID", "", "Lmod/lucky/common/Entity;", "world", "Lmod/lucky/common/World;", "uuid", "generateChestLoot", "Lmod/lucky/common/attribute/ListAttr;", "pos", "Lmod/lucky/common/Vec3;", "Lmod/lucky/common/Vec3i;", "lootTableId", "getArrowPosAndVelocity", "Lmod/lucky/kotlin/Pair;", "", "Lmod/lucky/common/Vec3d;", "player", "Lmod/lucky/common/PlayerEntity;", "bowPower", "yawOffsetDeg", "pitchOffsetDeg", "getBlockId", "block", "Lmod/lucky/common/Block;", "getEnchantments", "", "Lmod/lucky/java/Enchantment;", "types", "Lmod/lucky/java/EnchantmentType;", "getEntityTypeId", "entity", "getEntityUUID", "getEntityVelocity", "getGameDir", "Ljava/io/File;", "getItemId", "item", "Lmod/lucky/common/Item;", "getLoaderName", "getMinecraftVersion", "getModVersion", "getRBGPalette", "getStatusEffect", "Lmod/lucky/java/StatusEffect;", "hasSilkTouch", "", "isCreativeMode", "isValidItemId", "nbtToAttr", "tag", "Lmod/lucky/java/NBTTag;", "readCompressedNBT", "stream", "Ljava/io/InputStream;", "readNBTKey", "k", "readNBTStructure", "Lmod/lucky/java/NBTStructure;", "showClientMessage", "", "textJsonStr", "writeNBTKey", "v", "luckyblock"})
public final class ForgeJavaGameAPI
implements JavaGameAPI {
    @NotNull
    public static final ForgeJavaGameAPI INSTANCE = new ForgeJavaGameAPI();

    private ForgeJavaGameAPI() {
    }

    @Override
    @NotNull
    public String getLoaderName() {
        return "forge";
    }

    @Override
    @NotNull
    public String getModVersion() {
        return ForgeLuckyRegistry.INSTANCE.getModVersion();
    }

    @Override
    @NotNull
    public String getMinecraftVersion() {
        String string = MCPVersion.getMCVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getMCVersion()");
        return string;
    }

    @Override
    @NotNull
    public File getGameDir() {
        File file = FMLLoader.getGamePath().toFile();
        Intrinsics.checkNotNullExpressionValue(file, "getGamePath().toFile()");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public INBT attrToNBT(@NotNull Attr attr) {
        INBT iNBT;
        Intrinsics.checkNotNullParameter(attr, "attr");
        Attr attr2 = attr;
        if (attr2 instanceof ValueAttr) {
            INBT iNBT2;
            AttrType attrType = attr.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[attrType.ordinal()];
            switch (n) {
                case 1: {
                    iNBT2 = (INBT)StringNBT.func_229705_a_((String)((String)((ValueAttr)attr).getValue()));
                    break;
                }
                case 2: {
                    iNBT2 = (INBT)ByteNBT.func_229671_a_((byte)((Byte)((ValueAttr)attr).getValue()));
                    break;
                }
                case 3: {
                    iNBT2 = (INBT)ByteNBT.func_229672_a_((boolean)Intrinsics.areEqual(((ValueAttr)attr).getValue(), true));
                    break;
                }
                case 4: {
                    iNBT2 = (INBT)ShortNBT.func_229701_a_((short)((Short)((ValueAttr)attr).getValue()));
                    break;
                }
                case 5: {
                    iNBT2 = (INBT)IntNBT.func_229692_a_((int)((Integer)((ValueAttr)attr).getValue()));
                    break;
                }
                case 6: {
                    iNBT2 = (INBT)LongNBT.func_229698_a_((long)((Long)((ValueAttr)attr).getValue()));
                    break;
                }
                case 7: {
                    iNBT2 = (INBT)FloatNBT.func_229689_a_((float)((Float)((ValueAttr)attr).getValue()).floatValue());
                    break;
                }
                case 8: {
                    iNBT2 = (INBT)DoubleNBT.func_229684_a_((double)((Double)((ValueAttr)attr).getValue()));
                    break;
                }
                case 9: {
                    iNBT2 = (INBT)new IntArrayNBT((int[])((ValueAttr)attr).getValue());
                    break;
                }
                case 10: {
                    iNBT2 = (INBT)new ByteArrayNBT((byte[])((ValueAttr)attr).getValue());
                    break;
                }
                case 11: 
                case 12: {
                    throw new Exception();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            INBT iNBT3 = iNBT2;
            Intrinsics.checkNotNullExpressionValue(iNBT3, "when (attr.type) {\n                AttrType.STRING -> StringTag.valueOf(attr.value as String)\n                AttrType.BYTE -> ByteTag.valueOf(attr.value as Byte)\n                AttrType.BOOLEAN -> ByteTag.valueOf(attr.value == true)\n                AttrType.SHORT -> ShortTag.valueOf(attr.value as Short)\n                AttrType.INT -> IntTag.valueOf(attr.value as Int)\n                AttrType.LONG -> LongTag.valueOf(attr.value as Long)\n                AttrType.FLOAT -> FloatTag.valueOf(attr.value as Float)\n                AttrType.DOUBLE -> DoubleTag.valueOf(attr.value as Double)\n                AttrType.INT_ARRAY -> IntArrayTag(attr.value as IntArray)\n                AttrType.BYTE_ARRAY -> ByteArrayTag(attr.value as ByteArray)\n                AttrType.LIST, AttrType.DICT -> throw Exception()\n            }");
            iNBT = iNBT3;
        } else if (attr2 instanceof ListAttr) {
            ListNBT listTag = new ListNBT();
            Iterable $this$forEach$iv = ((ListAttr)attr).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attr it = (Attr)element$iv;
                boolean bl = false;
                listTag.add((Object)INSTANCE.attrToNBT(it));
            }
            iNBT = (INBT)listTag;
        } else if (attr2 instanceof DictAttr) {
            void var3_11;
            CompoundNBT dictTag = new CompoundNBT();
            Map<String, Attr> $this$forEach$iv = ((DictAttr)attr).getChildren();
            boolean $i$f$forEach = false;
            Map<String, Attr> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, Attr>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Attr> element$iv;
                Map.Entry<String, Attr> $dstr$k$v = element$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry<String, Attr> entry = $dstr$k$v;
                boolean bl3 = false;
                String k = entry.getKey();
                Map.Entry<String, Attr> entry2 = $dstr$k$v;
                boolean bl4 = false;
                Attr v = entry2.getValue();
                dictTag.func_218657_a(k, INSTANCE.attrToNBT(v));
            }
            iNBT = (INBT)var3_11;
        } else {
            throw new Exception();
        }
        return iNBT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Attr nbtToAttr(@NotNull Object tag) {
        Attr attr;
        Intrinsics.checkNotNullParameter(tag, "tag");
        Object object = tag;
        if (object instanceof StringNBT) {
            String string = ((StringNBT)tag).func_150285_a_();
            Intrinsics.checkNotNullExpressionValue(string, "tag.asString");
            attr = AttributeKt.stringAttrOf(string);
        } else if (object instanceof ByteNBT) {
            attr = new ValueAttr(AttrType.BYTE, ((ByteNBT)tag).func_150290_f(), false, 4, null);
        } else if (object instanceof ShortNBT) {
            attr = new ValueAttr(AttrType.SHORT, ((ShortNBT)tag).func_150289_e(), false, 4, null);
        } else if (object instanceof IntNBT) {
            attr = new ValueAttr(AttrType.INT, ((IntNBT)tag).func_150287_d(), false, 4, null);
        } else if (object instanceof LongNBT) {
            attr = new ValueAttr(AttrType.LONG, ((LongNBT)tag).func_150291_c(), false, 4, null);
        } else if (object instanceof FloatNBT) {
            attr = new ValueAttr(AttrType.FLOAT, Float.valueOf(((FloatNBT)tag).func_150288_h()), false, 4, null);
        } else if (object instanceof DoubleNBT) {
            attr = new ValueAttr(AttrType.DOUBLE, ((DoubleNBT)tag).func_150286_g(), false, 4, null);
        } else if (object instanceof ByteArrayNBT) {
            byte[] byArray = ((ByteArrayNBT)tag).func_150292_c();
            Intrinsics.checkNotNullExpressionValue(byArray, "tag.asByteArray");
            attr = new ValueAttr(AttrType.BYTE_ARRAY, byArray, false, 4, null);
        } else if (object instanceof IntArrayNBT) {
            int[] nArray = ((IntArrayNBT)tag).func_150302_c();
            Intrinsics.checkNotNullExpressionValue(nArray, "tag.asIntArray");
            attr = new ValueAttr(AttrType.INT_ARRAY, nArray, false, 4, null);
        } else if (object instanceof ListNBT) {
            Collection<Attr> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)tag;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                INBT iNBT = (INBT)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                Attr attr2 = INSTANCE.nbtToAttr(it);
                collection.add(attr2);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl = false;
            AttrType attrType = null;
            List list = collection;
            attr = new ListAttr(list, attrType, bl, n, defaultConstructorMarker);
        } else if (object instanceof CompoundNBT) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Set $i$f$map = ((CompoundNBT)tag).func_150296_c();
            Intrinsics.checkNotNullExpressionValue($i$f$map, "tag.allKeys");
            Iterable $this$map$iv = $i$f$map;
            boolean $i$f$map2 = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Attr attr3;
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                void v1 = it;
                INBT iNBT = ((CompoundNBT)tag).func_74781_a((String)it);
                if (iNBT == null) {
                    attr3 = null;
                } else {
                    void v;
                    INBT iNBT2 = iNBT;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    INBT iNBT3 = iNBT2;
                    void var18_37 = v1;
                    boolean bl5 = false;
                    Attr attr4 = INSTANCE.nbtToAttr(v);
                    v1 = var18_37;
                    attr3 = attr4;
                }
                Pair<void, Object> pair = TuplesKt.to(v1, attr3);
                collection.add(pair);
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            if (pairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Pair[] pairArray2 = pairArray;
            attr = AttributeKt.dictAttrOf(Arrays.copyOf(pairArray2, pairArray2.length));
        } else {
            throw new Exception();
        }
        return attr;
    }

    @Override
    @Nullable
    public Object readNBTKey(@NotNull Object tag, @NotNull String k) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(k, "k");
        return ((CompoundNBT)tag).func_74781_a(k);
    }

    @Override
    public void writeNBTKey(@NotNull Object tag, @NotNull String k, @NotNull Object v) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(k, "k");
        Intrinsics.checkNotNullParameter(v, "v");
        ((CompoundNBT)tag).func_218657_a(k, (INBT)v);
    }

    @Override
    @NotNull
    public Attr readCompressedNBT(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        CompoundNBT nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
        Intrinsics.checkNotNullExpressionValue(nbt, "nbt");
        return this.nbtToAttr(nbt);
    }

    @Override
    @NotNull
    public Pair<Vec3<Double>, Vec3<Double>> getArrowPosAndVelocity(@NotNull Object world, @NotNull Object player, double bowPower, double yawOffsetDeg, double pitchOffsetDeg) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        ArrowEntity arrowEntity = new ArrowEntity((World)((ServerWorld)world), (LivingEntity)((PlayerEntity)player));
        arrowEntity.func_234612_a_((Entity)player, (float)(GameAPIKt.getGameAPI().getPlayerHeadPitchDeg(player) + yawOffsetDeg), (float)(GameAPIKt.getGameAPI().getPlayerHeadYawDeg(player) + pitchOffsetDeg), 0.0f, (float)(bowPower * 3.0), 1.0f);
        return new Pair<Vec3<Double>, Vec3<Double>>(GameAPIKt.getGameAPI().getEntityPos(arrowEntity), new Vec3<Number>(arrowEntity.func_213322_ci().field_72450_a, arrowEntity.func_213322_ci().field_72448_b, arrowEntity.func_213322_ci().field_72449_c));
    }

    @Override
    @NotNull
    public Vec3<Double> getEntityVelocity(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Vector3d vector3d = ((Entity)entity).func_213322_ci();
        Intrinsics.checkNotNullExpressionValue(vector3d, "entity as MCEntity).deltaMovement");
        return ForgeGameAPIKt.toVec3d(vector3d);
    }

    @Override
    @NotNull
    public String getEntityUUID(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        String string = ((Entity)entity).func_110124_au().toString();
        Intrinsics.checkNotNullExpressionValue(string, "entity as MCEntity).uuid.toString()");
        return string;
    }

    @Override
    @Nullable
    public Object findEntityByUUID(@NotNull Object world, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return ((ServerWorld)world).func_217461_a(UUID.fromString(uuid));
    }

    @Override
    @OnlyInClient
    public void showClientMessage(@NotNull String textJsonStr) {
        Intrinsics.checkNotNullParameter(textJsonStr, "textJsonStr");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IFormattableTextComponent mcText = ITextComponent.Serializer.func_240643_a_((String)textJsonStr);
        if (mcText == null) {
            GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Invalid JSON text: ", textJsonStr), null, 2, null);
            return;
        }
        ClientPlayerEntity clientPlayerEntity = player;
        if (clientPlayerEntity != null) {
            clientPlayerEntity.func_145747_a((ITextComponent)mcText, UUID.fromString(this.getEntityUUID(player)));
        }
    }

    @Override
    @Nullable
    public String getBlockId(@NotNull Object block) {
        Intrinsics.checkNotNullParameter(block, "block");
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)((Block)block));
        return resourceLocation == null ? null : resourceLocation.toString();
    }

    @Override
    @Nullable
    public String getItemId(@NotNull Object item) {
        Intrinsics.checkNotNullParameter(item, "item");
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)item));
        return resourceLocation == null ? null : resourceLocation.toString();
    }

    @Override
    public boolean isValidItemId(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return ForgeRegistries.ITEMS.containsKey(new ResourceLocation(id));
    }

    @Override
    @NotNull
    public String getEntityTypeId(@NotNull Object entity) {
        String string;
        ResourceLocation key;
        Intrinsics.checkNotNullParameter(entity, "entity");
        ResourceLocation resourceLocation = key = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((Entity)entity).func_200600_R());
        return resourceLocation == null ? "" : ((string = resourceLocation.toString()) == null ? "" : string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> getRBGPalette() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ArraysKt.toList(DyeColor.values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DyeColor dyeColor = (DyeColor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float[] c = it.func_193349_f();
            Integer n = new Color(c[0], c[1], c[2]).getRGB();
            collection.add(n);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ListAttr generateChestLoot(@NotNull Object world, @NotNull Vec3<Integer> pos, @NotNull String lootTableId) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(lootTableId, "lootTableId");
        ChestTileEntity chestEntity = new ChestTileEntity();
        chestEntity.func_189404_a(new ResourceLocation(lootTableId), UtilsKt.getRANDOM().nextLong());
        chestEntity.func_226984_a_((World)world, ForgeGameAPIKt.toMCBlockPos(pos));
        chestEntity.func_184281_d(null);
        CompoundNBT tag = new CompoundNBT();
        chestEntity.func_189515_b(tag);
        JavaGameAPI javaGameAPI = JavaGameAPIKt.getJavaGameAPI();
        Object object = JavaGameAPIKt.getJavaGameAPI().readNBTKey(tag, "Items");
        Intrinsics.checkNotNull(object);
        return (ListAttr)javaGameAPI.nbtToAttr(object);
    }

    @Override
    @NotNull
    public List<Enchantment> getEnchantments(@NotNull List<? extends EnchantmentType> types) {
        Iterable $this$filterTo$iv$iv;
        Object object;
        Map.Entry it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(types, "types");
        Iterable $this$map$iv = types;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EnchantmentType enchantmentType = (EnchantmentType)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            object = ForgeJavaGameAPIKt.access$toMCEnchantmentType((EnchantmentType)((Object)it));
            collection.add(object);
        }
        List mcTypes = (List)destination$iv$iv;
        $this$map$iv = ForgeRegistries.ENCHANTMENTS.getEntries();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "ENCHANTMENTS.entries");
        Iterable $this$filter$iv = $this$map$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!mcTypes.contains(((net.minecraft.enchantment.Enchantment)it.getValue()).field_77351_y)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((RegistryKey)it.getKey()).toString();
            Intrinsics.checkNotNullExpressionValue(string, "it.key.toString()");
            object = new Enchantment(string, ((net.minecraft.enchantment.Enchantment)it.getValue()).func_77325_b(), ((net.minecraft.enchantment.Enchantment)it.getValue()).func_190936_d());
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public StatusEffect getStatusEffect(@NotNull String id) {
        Object object;
        Intrinsics.checkNotNullParameter(id, "id");
        ResourceLocation mcId = new ResourceLocation(id);
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(mcId);
        if (effect == null) {
            return null;
        }
        Effect effect2 = object = effect;
        object = mcId.toString();
        Intrinsics.checkNotNullExpressionValue(object, "mcId.toString()");
        return new StatusEffect((String)object, Effect.func_188409_a((Effect)effect2), effect2.func_76403_b());
    }

    @Override
    public boolean isCreativeMode(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((PlayerEntity)player).func_184812_l_();
    }

    @Override
    public boolean hasSilkTouch(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return EnchantmentHelper.func_185284_a((net.minecraft.enchantment.Enchantment)Enchantments.field_185306_r, (LivingEntity)((LivingEntity)((PlayerEntity)player))) > 0;
    }

    @Override
    @Nullable
    public String convertLegacyItemId(int id, int data) {
        String string = ItemIntIDToString.func_199173_a((int)id);
        Intrinsics.checkNotNullExpressionValue(string, "getItem(id)");
        String legacyName = string;
        if (Intrinsics.areEqual(legacyName, "minecraft:air") && id > 0) {
            return null;
        }
        string = ItemStackDataFlattening.func_199175_a((String)legacyName, (int)data);
        return string == null ? legacyName : string;
    }

    @Override
    @NotNull
    public Pair<Object, Vec3<Integer>> readNBTStructure(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Template structure = new Template();
        structure.func_186256_b(CompressedStreamTools.func_74796_a((InputStream)stream));
        BlockPos blockPos = structure.func_186259_a();
        Intrinsics.checkNotNullExpressionValue(blockPos, "structure.size");
        return new Pair<Template, Vec3<Integer>>(structure, ForgeGameAPIKt.toVec3i((Vector3i)blockPos));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttrType.values().length];
            nArray[AttrType.STRING.ordinal()] = 1;
            nArray[AttrType.BYTE.ordinal()] = 2;
            nArray[AttrType.BOOLEAN.ordinal()] = 3;
            nArray[AttrType.SHORT.ordinal()] = 4;
            nArray[AttrType.INT.ordinal()] = 5;
            nArray[AttrType.LONG.ordinal()] = 6;
            nArray[AttrType.FLOAT.ordinal()] = 7;
            nArray[AttrType.DOUBLE.ordinal()] = 8;
            nArray[AttrType.INT_ARRAY.ordinal()] = 9;
            nArray[AttrType.BYTE_ARRAY.ordinal()] = 10;
            nArray[AttrType.LIST.ordinal()] = 11;
            nArray[AttrType.DICT.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

