/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.forge;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.lucky.common.GameAPI;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.action.DropActionsKt;
import mod.lucky.forge.ForgeGameAPIKt;
import mod.lucky.forge.ForgeLuckyRegistry;
import mod.lucky.forge.game.DelayedDrop;
import mod.lucky.java.JavaGameAPI;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.JavaLuckyRegistry;
import mod.lucky.java.game.DelayedDropData;
import mod.lucky.java.game.GameUtilsKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.random.PlatformRandomKt;
import mod.lucky.kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0010H\u0016J6\u0010\u0012\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JX\u0010\u001b\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0006\u0010\u001c\u001a\u00020\u00052\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00100\u0016j\u0002`\u001d2\u0010\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\u00100\u0016j\u0002`\u001d2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001aH\u0016J8\u0010\"\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001e\u0010&\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016JB\u0010'\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00042\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010(\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0010\u0010)\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u0017H\u0016J.\u0010*\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`+2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u0017H\u0016J\u0014\u0010,\u001a\u00020\u000e2\n\u0010-\u001a\u00060\nj\u0002`+H\u0016J\u0014\u0010.\u001a\u00020\u000e2\n\u0010-\u001a\u00060\nj\u0002`+H\u0016J\u0014\u0010/\u001a\u00020\u00052\n\u0010-\u001a\u00060\nj\u0002`+H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0014\u00102\u001a\u0002032\n\u0010\u0013\u001a\u00060\nj\u0002`\u0014H\u0016J\u0006\u00104\u001a\u00020\bJ&\u00105\u001a\u00020\u001a2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00100\u0016j\u0002`\u001dH\u0016J\"\u00106\u001a\u00020\b2\b\u00107\u001a\u0004\u0018\u00010\u00052\u000e\u00108\u001a\n\u0018\u000109j\u0004\u0018\u0001`:H\u0016J\u0010\u0010;\u001a\u00020\b2\u0006\u00107\u001a\u00020\u0005H\u0016J6\u0010<\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u0010H\u0016J>\u0010?\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u000eH\u0016J?\u0010C\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\b\u0010D\u001a\u0004\u0018\u00010\u00052\b\u0010E\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010FJ>\u0010G\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u001aH\u0016J \u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u000eH\u0016J\u001c\u0010Q\u001a\u00020\b2\n\u0010-\u001a\u00060\nj\u0002`+2\u0006\u0010R\u001a\u00020\u0005H\u0016JH\u0010S\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00100\u0016j\u0002`\u001d2\u0006\u0010T\u001a\u00020\u00052\b\u0010U\u001a\u0004\u0018\u00010%2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001aH\u0016J.\u0010V\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00100\u0016j\u0002`\u001d2\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010W\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0006\u0010X\u001a\u00020\u0005H\u0016J&\u0010Y\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0010\u0010Z\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u0017H\u0016J\u001c\u0010[\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u001c\u0010\\\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0006\u0010]\u001a\u000203H\u0016J^\u0010^\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0006\u0010@\u001a\u00020\u00052\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u001a2\u000e\u0010-\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`+2\u0006\u0010`\u001a\u00020\u0005H\u0016JV\u0010a\u001a\u00020\b2\n\u0010\u0013\u001a\u00060\nj\u0002`\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010@\u001a\u00020\u00052\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0010\u0010c\u001a\f\u0012\u0004\u0012\u00020\u000e0\u0016j\u0002`\u00172\u0006\u0010d\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lmod/lucky/forge/ForgeGameAPI;", "Lmod/lucky/common/GameAPI;", "()V", "spawnEggIds", "", "", "usefulPotionIds", "applyStatusEffect", "", "entity", "", "Lmod/lucky/common/Entity;", "effectId", "durationSeconds", "", "amplifier", "", "convertStatusEffectId", "createExplosion", "world", "Lmod/lucky/common/World;", "pos", "Lmod/lucky/common/Vec3;", "Lmod/lucky/common/Vec3d;", "damage", "fire", "", "createStructure", "structureId", "Lmod/lucky/common/Vec3i;", "centerOffset", "rotation", "mode", "notify", "dropItem", "itemId", "nbt", "Lmod/lucky/common/attribute/DictAttr;", "getEntityPos", "getLivingEntitiesInBox", "boxMin", "boxMax", "getNearestPlayer", "Lmod/lucky/common/PlayerEntity;", "getPlayerHeadPitchDeg", "player", "getPlayerHeadYawDeg", "getPlayerName", "getSpawnEggIds", "getUsefulPotionIds", "getWorldTime", "", "init", "isAirBlock", "logError", "msg", "error", "Ljava/lang/Exception;", "Lmod/lucky/kotlin/Exception;", "logInfo", "playParticleEvent", "eventId", "data", "playSound", "id", "volume", "pitch", "playSplashPotionEvent", "potionName", "potionColor", "(Ljava/lang/Object;Lmod/lucky/common/Vec3;Ljava/lang/String;Ljava/lang/Integer;)V", "runCommand", "command", "senderName", "showOutput", "scheduleDrop", "drop", "Lmod/lucky/common/drop/SingleDrop;", "context", "Lmod/lucky/common/drop/DropContext;", "seconds", "sendMessage", "message", "setBlock", "blockId", "state", "setBlockEntity", "setDifficulty", "difficulty", "setEntityMotion", "motion", "setEntityOnFire", "setTime", "time", "spawnEntity", "randomizeMob", "sourceId", "spawnParticle", "args", "boxSize", "amount", "luckyblock"})
public final class ForgeGameAPI
implements GameAPI {
    @NotNull
    public static final ForgeGameAPI INSTANCE = new ForgeGameAPI();
    @NotNull
    private static List<String> usefulPotionIds = CollectionsKt.emptyList();
    @NotNull
    private static List<String> spawnEggIds = CollectionsKt.emptyList();

    private ForgeGameAPI() {
    }

    /*
     * Unable to fully structure code
     */
    public final void init() {
        var1_1 = ForgeRegistries.POTION_TYPES.getKeys();
        Intrinsics.checkNotNullExpressionValue(var1_1, "POTION_TYPES.keys");
        $this$filter$iv = var1_1;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceLocation)element$iv$iv;
            $i$a$-filter-ForgeGameAPI$init$1 = false;
            if (!(Intrinsics.areEqual(it.func_110624_b(), "minecraft") != false && GameUtilsKt.getUselessPostionNames().contains(it.func_110623_a()) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceLocation)item$iv$iv;
            var11_10 = destination$iv$iv;
            $i$a$-map-ForgeGameAPI$init$2 = false;
            var12_11 = it.toString();
            var11_10.add(var12_11);
        }
        ForgeGameAPI.usefulPotionIds = CollectionsKt.toList((List)destination$iv$iv);
        $this$map$iv = ForgeRegistries.ITEMS.getKeys();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "ITEMS.keys");
        $this$filter$iv = $this$map$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceLocation)element$iv$iv;
            $i$a$-filter-ForgeGameAPI$init$3 = false;
            if (!Intrinsics.areEqual(it.func_110624_b(), "minecraft")) ** GOTO lbl-1000
            var10_12 = it.func_110623_a();
            Intrinsics.checkNotNullExpressionValue(var10_12, "it.path");
            if (StringsKt.endsWith$default(var10_12, "_spawn_egg", false, 2, null)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceLocation)item$iv$iv;
            var11_10 = destination$iv$iv;
            $i$a$-map-ForgeGameAPI$init$4 = false;
            var12_11 = it.toString();
            var11_10.add(var12_11);
        }
        ForgeGameAPI.spawnEggIds = CollectionsKt.toList((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public List<String> getUsefulPotionIds() {
        return usefulPotionIds;
    }

    @Override
    @NotNull
    public List<String> getSpawnEggIds() {
        return spawnEggIds;
    }

    @Override
    public void logError(@Nullable String msg, @Nullable Exception error) {
        if (msg != null && error != null) {
            ForgeLuckyRegistry.INSTANCE.getLOGGER().error(msg, (Throwable)error);
        } else if (msg != null) {
            ForgeLuckyRegistry.INSTANCE.getLOGGER().error(msg);
        } else {
            ForgeLuckyRegistry.INSTANCE.getLOGGER().error((Object)error);
        }
    }

    @Override
    public void logInfo(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        ForgeLuckyRegistry.INSTANCE.getLOGGER().info(msg);
    }

    @Override
    @NotNull
    public Vec3<Double> getEntityPos(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        return new Vec3<Number>(((Entity)entity).func_226277_ct_(), ((Entity)entity).func_226278_cu_(), ((Entity)entity).func_226281_cx_());
    }

    @Override
    @NotNull
    public String getPlayerName(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = ((PlayerEntity)player).func_200200_C_().getString();
        Intrinsics.checkNotNullExpressionValue(string, "player as MCPlayerEntity).name.string");
        return string;
    }

    @Override
    public void applyStatusEffect(@NotNull Object entity, @NotNull String effectId, double durationSeconds, int amplifier) {
        int duration;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(effectId, "effectId");
        Effect statusEffect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectId));
        if (statusEffect == null) {
            GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Unknown status effect: ", effectId), null, 2, null);
            return;
        }
        int n = duration = statusEffect.func_76403_b() ? 1 : (int)(durationSeconds * 20.0);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(statusEffect, duration, amplifier));
        }
    }

    @Override
    @Nullable
    public String convertStatusEffectId(int effectId) {
        String string;
        Effect effect = Effect.func_188412_a((int)effectId);
        Effect effect2 = effect;
        if (effect2 == null) {
            string = null;
        } else {
            Effect effect3 = effect2;
            boolean bl = false;
            boolean bl2 = false;
            Effect it = effect3;
            boolean bl3 = false;
            string = String.valueOf(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect));
        }
        return string;
    }

    @Override
    @NotNull
    public List<Object> getLivingEntitiesInBox(@NotNull Object world, @NotNull Vec3<Double> boxMin, @NotNull Vec3<Double> boxMax) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(boxMin, "boxMin");
        Intrinsics.checkNotNullParameter(boxMax, "boxMax");
        AxisAlignedBB box = new AxisAlignedBB(ForgeGameAPIKt.toMCVec3d(boxMin), ForgeGameAPIKt.toMCVec3d(boxMax));
        List list = ForgeGameAPIKt.toServerWorld(world).func_217357_a(LivingEntity.class, box);
        Intrinsics.checkNotNullExpressionValue(list, "toServerWorld(world).getEntitiesOfClass(LivingEntity::class.java, box)");
        return list;
    }

    @Override
    public void setEntityOnFire(@NotNull Object entity, int durationSeconds) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        ((Entity)entity).func_70015_d(durationSeconds);
    }

    @Override
    public void setEntityMotion(@NotNull Object entity, @NotNull Vec3<Double> motion) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(motion, "motion");
        ((Entity)entity).func_213317_d(ForgeGameAPIKt.toMCVec3d(motion));
        ((Entity)entity).field_70133_I = true;
        ((Entity)entity).field_70160_al = true;
    }

    @Override
    public long getWorldTime(@NotNull Object world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return ForgeGameAPIKt.toServerWorld(world).func_72820_D();
    }

    @Override
    public double getPlayerHeadYawDeg(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((PlayerEntity)player).field_70759_as;
    }

    @Override
    public double getPlayerHeadPitchDeg(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((PlayerEntity)player).field_70125_A;
    }

    @Override
    public boolean isAirBlock(@NotNull Object world, @NotNull Vec3<Integer> pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        return ((IWorld)world).func_175623_d(ForgeGameAPIKt.toMCBlockPos(pos));
    }

    @Override
    public void spawnEntity(@NotNull Object world, @NotNull String id, @NotNull Vec3<Double> pos, @NotNull DictAttr nbt, double rotation, boolean randomizeMob, @Nullable Object player, @NotNull String sourceId) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        DictAttr entityNBT = Intrinsics.areEqual(id, "lucky:lucky_projectile") && !nbt.contains("sourceId") ? nbt.with(MapsKt.mapOf(TuplesKt.to("sourceId", AttributeKt.stringAttrOf(sourceId)))) : nbt;
        CompoundNBT mcEntityNBT = (CompoundNBT)JavaGameAPIKt.getJavaGameAPI().attrToNBT(nbt.with(MapsKt.mapOf(TuplesKt.to("id", AttributeKt.stringAttrOf(id)))));
        ServerWorld serverWorld = ForgeGameAPIKt.toServerWorld(world);
        Entity entity = EntityType.func_220335_a((CompoundNBT)mcEntityNBT, (World)((World)serverWorld), arg_0 -> ForgeGameAPI.spawnEntity$lambda-5(rotation, pos, serverWorld, arg_0));
        if (entity == null) {
            return;
        }
        Entity entity2 = entity;
        Entity entity3 = entity2;
        if (entity3 instanceof FallingBlockEntity && !entityNBT.contains("Time")) {
            ((FallingBlockEntity)entity3).field_145812_b = 1;
        }
        if (player != null && entity3 instanceof ArrowEntity) {
            ((ArrowEntity)entity3).func_212361_a((Entity)player);
        }
        if (entity3 instanceof MobEntity && randomizeMob && !entityNBT.contains("Passengers")) {
            ((MobEntity)entity3).func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(ForgeGameAPIKt.toMCBlockPos(pos.floor())), SpawnReason.EVENT, null, null);
            ((MobEntity)entity3).func_70037_a(mcEntityNBT);
        }
    }

    @Override
    @Nullable
    public Object getNearestPlayer(@NotNull Object world, @NotNull Vec3<Double> pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        CommandSource commandSource = ForgeGameAPIKt.createCommandSource$default((ServerWorld)world, pos, null, false, 4, null);
        return new EntitySelectorParser(new StringReader("@p")).func_201345_m().func_197347_c(commandSource);
    }

    @Override
    public void scheduleDrop(@NotNull SingleDrop drop, @NotNull DropContext context, double seconds) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        ServerWorld world = ForgeGameAPIKt.toServerWorld(context.getWorld());
        DelayedDrop delayedDrop = new DelayedDrop(null, (World)world, new DelayedDropData(drop, context, (int)(seconds * (double)20)), 1, null);
        delayedDrop.func_70107_b(context.getPos().getX(), context.getPos().getY(), context.getPos().getZ());
        world.func_217376_c((Entity)delayedDrop);
    }

    @Override
    public void setBlock(@NotNull Object world, @NotNull Vec3<Integer> pos, @NotNull String blockId, @Nullable DictAttr state, int rotation, boolean notify) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(blockId, "blockId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("Name", AttributeKt.stringAttrOf(blockId)), TuplesKt.to("Properties", state)};
        CompoundNBT blockStateNBT = (CompoundNBT)JavaGameAPIKt.getJavaGameAPI().attrToNBT(AttributeKt.dictAttrOf(pairArray));
        BlockState mcBlockState = NBTUtil.func_190008_d((CompoundNBT)blockStateNBT).rotate((IWorld)world, ForgeGameAPIKt.toMCBlockPos(pos), Rotation.values()[rotation]);
        ((IWorld)world).func_180501_a(ForgeGameAPIKt.toMCBlockPos(pos), mcBlockState, notify ? 3 : 2);
    }

    @Override
    public void setBlockEntity(@NotNull Object world, @NotNull Vec3<Integer> pos, @NotNull DictAttr nbt) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        BlockPos mcPos = ForgeGameAPIKt.toMCBlockPos(pos);
        TileEntity blockEntity = ((IServerWorld)world).func_175625_s(mcPos);
        if (blockEntity != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("x", AttributeKt.intAttrOf(pos.getX())), TuplesKt.to("y", AttributeKt.intAttrOf(pos.getY())), TuplesKt.to("z", AttributeKt.intAttrOf(pos.getZ()))};
            DictAttr fullNBT = nbt.with(MapsKt.mapOf(pairArray));
            blockEntity.func_230337_a_(((IServerWorld)world).func_180495_p(mcPos), (CompoundNBT)JavaGameAPIKt.getJavaGameAPI().attrToNBT(fullNBT));
            blockEntity.func_70296_d();
        }
    }

    @Override
    public void dropItem(@NotNull Object world, @NotNull Vec3<Double> pos, @NotNull String itemId, @Nullable DictAttr nbt) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(itemId, "itemId");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), "Invalid item ID: '" + itemId + '\'', null, 2, null);
            return;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)item, 1);
        if (nbt != null) {
            itemStack.func_77982_d((CompoundNBT)JavaGameAPIKt.getJavaGameAPI().attrToNBT(nbt));
        }
        Block.func_180635_a((World)((World)ForgeGameAPIKt.toServerWorld(world)), (BlockPos)ForgeGameAPIKt.toMCBlockPos(pos.floor()), (ItemStack)itemStack);
    }

    @Override
    public void runCommand(@NotNull Object world, @NotNull Vec3<Double> pos, @NotNull String command, @NotNull String senderName, boolean showOutput) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(senderName, "senderName");
        try {
            CommandSource commandSource = ForgeGameAPIKt.access$createCommandSource(ForgeGameAPIKt.toServerWorld(world), pos, senderName, showOutput);
            commandSource.func_197028_i().func_195571_aL().func_197059_a(commandSource, command);
        }
        catch (Exception e) {
            GameAPIKt.getGameAPI().logError(Intrinsics.stringPlus("Invalid command: ", command), e);
        }
    }

    @Override
    public void sendMessage(@NotNull Object player, @NotNull String message) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(message, "message");
        ((PlayerEntity)player).func_146105_b((ITextComponent)new StringTextComponent(message), false);
    }

    @Override
    public void setDifficulty(@NotNull Object world, @NotNull String difficulty) {
        Difficulty difficulty2;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(difficulty, "difficulty");
        switch (difficulty) {
            case "peaceful": {
                difficulty2 = Difficulty.PEACEFUL;
                break;
            }
            case "easy": {
                difficulty2 = Difficulty.EASY;
                break;
            }
            case "normal": {
                difficulty2 = Difficulty.NORMAL;
                break;
            }
            default: {
                difficulty2 = Difficulty.HARD;
            }
        }
        Difficulty difficultyEnum = difficulty2;
        ForgeGameAPIKt.toServerWorld(world).func_73046_m().func_147139_a(difficultyEnum, false);
    }

    @Override
    public void setTime(@NotNull Object world, long time) {
        Intrinsics.checkNotNullParameter(world, "world");
        ForgeGameAPIKt.toServerWorld(world).func_241114_a_(time);
    }

    @Override
    public void playSound(@NotNull Object world, @NotNull Vec3<Double> pos, @NotNull String id, double volume, double pitch) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(id, "id");
        SoundEvent soundEvent = (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation(id));
        if (soundEvent == null) {
            GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Invalid sound event: ", id), null, 2, null);
            return;
        }
        ForgeGameAPIKt.toServerWorld(world).func_184148_a(null, ((Number)pos.getX()).doubleValue(), ((Number)pos.getY()).doubleValue(), ((Number)pos.getZ()).doubleValue(), soundEvent, SoundCategory.BLOCKS, (float)volume, (float)pitch);
    }

    @Override
    public void spawnParticle(@NotNull Object world, @NotNull Vec3<Double> pos, @NotNull String id, @NotNull List<String> args2, @NotNull Vec3<Double> boxSize, int amount) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(boxSize, "boxSize");
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(id));
        if (particleType == null) {
            GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Invalid partical: ", id), null, 2, null);
            return;
        }
        try {
            IParticleData iParticleData;
            try {
                iParticleData = particleType.func_197571_g().func_197544_b(particleType, new StringReader(Intrinsics.stringPlus(" ", CollectionsKt.joinToString$default(args2, " ", null, null, 0, null, null, 62, null))));
            }
            catch (CommandSyntaxException e) {
                GameAPIKt.getGameAPI().logError("Error processing partice '" + id + "' with arguments '" + args2 + '\'', (Exception)((Object)e));
                return;
            }
            IParticleData particleData = iParticleData;
            ForgeGameAPIKt.toServerWorld(world).func_195598_a(particleData, ((Number)pos.getX()).doubleValue(), ((Number)pos.getY()).doubleValue(), ((Number)pos.getZ()).doubleValue(), amount, ((Number)boxSize.getX()).doubleValue(), ((Number)boxSize.getY()).doubleValue(), ((Number)boxSize.getZ()).doubleValue(), 0.0);
        }
        catch (Exception e) {
            GameAPIKt.getGameAPI().logError(Intrinsics.stringPlus("Invalid partical arguments: ", args2), e);
            return;
        }
    }

    @Override
    public void playParticleEvent(@NotNull Object world, @NotNull Vec3<Double> pos, int eventId, int data) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        ForgeGameAPIKt.toServerWorld(world).func_217379_c(eventId, ForgeGameAPIKt.toMCBlockPos(pos.floor()), data);
    }

    @Override
    public void playSplashPotionEvent(@NotNull Object world, @NotNull Vec3<Double> pos, @Nullable String potionName, @Nullable Integer potionColor) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        if (potionName != null) {
            Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(potionName));
            if (potion == null) {
                GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Invalid splash potion name: ", potionName), null, 2, null);
                return;
            }
            int color = PotionUtils.func_185181_a((Collection)potion.func_185170_a());
            this.playParticleEvent(world, pos, potion.func_185172_c() ? 2007 : 2002, color);
        } else if (potionColor != null) {
            this.playParticleEvent(world, pos, 2002, potionColor);
        }
    }

    @Override
    public void createExplosion(@NotNull Object world, @NotNull Vec3<Double> pos, double damage, boolean fire) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        ForgeGameAPIKt.toServerWorld(world).func_217398_a(null, ((Number)pos.getX()).doubleValue(), ((Number)pos.getY()).doubleValue(), ((Number)pos.getZ()).doubleValue(), (float)damage, fire, Explosion.Mode.DESTROY);
    }

    @Override
    public void createStructure(@NotNull Object world, @NotNull String structureId, @NotNull Vec3<Integer> pos, @NotNull Vec3<Integer> centerOffset, int rotation, @NotNull String mode, boolean notify) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(structureId, "structureId");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(centerOffset, "centerOffset");
        Intrinsics.checkNotNullParameter(mode, "mode");
        Object nbtStructure = JavaLuckyRegistry.INSTANCE.getNbtStructures().get(structureId);
        StructureProcessor processor2 = new StructureProcessor(mode){
            final /* synthetic */ String $mode;
            {
                this.$mode = $mode;
            }

            @NotNull
            public Template.BlockInfo process(@NotNull IWorldReader world, @NotNull BlockPos oldPos, @NotNull BlockPos newPos, @NotNull Template.BlockInfo oldBlockInfo, @NotNull Template.BlockInfo newBlockInfo, @NotNull PlacementSettings settings, @Nullable Template template) {
                Block block;
                Intrinsics.checkNotNullParameter(world, "world");
                Intrinsics.checkNotNullParameter(oldPos, "oldPos");
                Intrinsics.checkNotNullParameter(newPos, "newPos");
                Intrinsics.checkNotNullParameter(oldBlockInfo, "oldBlockInfo");
                Intrinsics.checkNotNullParameter(newBlockInfo, "newBlockInfo");
                Intrinsics.checkNotNullParameter(settings, "settings");
                JavaGameAPI javaGameAPI = JavaGameAPIKt.getJavaGameAPI();
                Block block2 = newBlockInfo.field_186243_b.func_177230_c();
                Intrinsics.checkNotNullExpressionValue(block2, "newBlockInfo.state.block");
                String string = javaGameAPI.getBlockId(block2);
                if (string == null) {
                    return newBlockInfo;
                }
                String blockId = string;
                String blockIdWithMode = DropActionsKt.withBlockMode(this.$mode, blockId);
                if (Intrinsics.areEqual(blockIdWithMode, blockId)) {
                    return newBlockInfo;
                }
                BlockState newState = blockIdWithMode == null ? world.func_180495_p(newBlockInfo.field_186242_a) : ((block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockIdWithMode))) == null ? null : block.func_176223_P());
                return Intrinsics.areEqual(newState, newBlockInfo.field_186243_b) ? newBlockInfo : new Template.BlockInfo(newBlockInfo.field_186242_a, newState, newBlockInfo.field_186244_c);
            }

            @NotNull
            protected IStructureProcessorType<?> func_215192_a() {
                IStructureProcessorType iStructureProcessorType = IStructureProcessorType.field_214920_b;
                Intrinsics.checkNotNullExpressionValue(iStructureProcessorType, "BLOCK_IGNORE");
                return iStructureProcessorType;
            }
        };
        Rotation mcRotation = Rotation.values()[rotation];
        PlacementSettings placementSettings = new PlacementSettings().func_186220_a(mcRotation).func_207665_a(ForgeGameAPIKt.toMCBlockPos(centerOffset)).func_186222_a(false).func_215222_a(processor2);
        Intrinsics.checkNotNullExpressionValue(placementSettings, "PlacementSettings()\n            .setRotation(mcRotation)\n            .setRotationPivot(toMCBlockPos(centerOffset))\n            .setIgnoreEntities(false)\n            .addProcessor(processor)");
        PlacementSettings placementSettings2 = placementSettings;
        BlockPos mcCornerPos = ForgeGameAPIKt.toMCBlockPos(pos.minus(centerOffset));
        if (nbtStructure == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.gen.feature.template.Template");
        }
        ((Template)nbtStructure).func_237146_a_((IServerWorld)world, mcCornerPos, mcCornerPos, placementSettings2, PlatformRandomKt.asJavaRandom(UtilsKt.getRANDOM()), notify ? 3 : 2);
    }

    private static final Entity spawnEntity$lambda-5(double $rotation, Vec3 $pos, ServerWorld $serverWorld, Entity entity) {
        Vector3d vector3d;
        Intrinsics.checkNotNullParameter($pos, "$pos");
        Intrinsics.checkNotNullParameter($serverWorld, "$serverWorld");
        double entityRotation = UtilsKt.positiveMod($rotation + 2.0, 4.0);
        double rotationDeg = entityRotation * 90.0;
        double yaw = UtilsKt.positiveMod((double)entity.field_70177_z + entityRotation, 360.0);
        if (entityRotation == 0.0) {
            vector3d = entity.func_213322_ci();
        } else {
            Vector3d vector3d2 = entity.func_213322_ci();
            Intrinsics.checkNotNullExpressionValue(vector3d2, "entity.deltaMovement");
            vector3d = ForgeGameAPIKt.toMCVec3d(UtilsKt.rotateVec3d(ForgeGameAPIKt.toVec3d(vector3d2), UtilsKt.degToRad(rotationDeg)));
        }
        Vector3d velocity = vector3d;
        entity.func_70080_a(((Number)$pos.getX()).doubleValue(), ((Number)$pos.getY()).doubleValue(), ((Number)$pos.getZ()).doubleValue(), (float)yaw, entity.field_70125_A);
        entity.func_70034_d((float)yaw);
        entity.func_213317_d(velocity);
        return $serverWorld.func_217376_c(entity) ? entity : null;
    }
}

