/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.upload.CrashyUpload;
import fudge.notenoughcrashes.upload.LegacyCrashLogUpload;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ProblemScreen
extends Screen {
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader", "quilt_loader", "forge", "notenoughcrashes"));
    private static final int GREEN = 65280;
    private static final ITextComponent uploadToCrashyText = NecLocalization.translatedText("notenoughcrashes.gui.uploadToCrashy").func_230531_f_().func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)65280)));
    private static final ITextComponent uploadToCrashyLoadingText = NecLocalization.translatedText("notenoughcrashes.gui.loadingCrashyUpload");
    private List<Widget> widgets = new ArrayList<Widget>();
    protected CrashReport report;
    private String uploadedCrashLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private String crashyLink = null;

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(CrashReport var1);

    protected ProblemScreen(CrashReport report) {
        super((ITextComponent)new StringTextComponent(""));
        this.report = report;
    }

    private ITextComponent getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.report);
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.id()));
        if (suspectedMods.isEmpty()) {
            return NecLocalization.translatedText("notenoughcrashes.crashscreen.noModsErrored");
        }
        return (ITextComponent)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::name)).map(mod -> {
            String issuesPage = mod.issuesPage();
            StringTextComponent modText = new StringTextComponent(mod.name());
            if (issuesPage != null) {
                modText.func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.func_230529_a_((ITextComponent)new StringTextComponent(", ")).func_230529_a_((ITextComponent)next)).get();
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.field_230712_o_, this.field_230708_k_ / 2, this.y + 29));
    }

    private void handleLegacyLinkClick(Button buttonWidget) {
        try {
            if (this.uploadedCrashLink == null) {
                this.uploadedCrashLink = LegacyCrashLogUpload.upload(this.report.func_71502_e());
            }
            Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmOpenLinkScreen(b -> {
                if (b) {
                    Util.func_110647_a().func_195640_a(this.uploadedCrashLink);
                }
                Minecraft.func_71410_x().func_147108_a((Screen)this.construct(this.report));
            }, this.uploadedCrashLink, true));
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception when crash menu button clicked:", e);
            buttonWidget.func_238482_a_(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.field_230693_o_ = false;
        }
    }

    private void handleCrashyUploadClick(Button buttonWidget) {
        try {
            if (this.crashyLink == null) {
                buttonWidget.field_230693_o_ = false;
                buttonWidget.func_238482_a_(uploadToCrashyLoadingText);
                CrashyUpload.uploadToCrashy(this.report.func_71502_e()).thenAccept(link -> {
                    this.crashyLink = link;
                    buttonWidget.field_230693_o_ = true;
                    buttonWidget.func_238482_a_(uploadToCrashyText);
                    Util.func_110647_a().func_195640_a(this.crashyLink);
                });
            } else {
                Util.func_110647_a().func_195640_a(this.crashyLink);
            }
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception uploading to crashy", e);
            buttonWidget.func_238482_a_(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.field_230693_o_ = false;
        }
    }

    public void func_231160_c_() {
        this.widgets = new ArrayList<Widget>();
        this.func_230480_a_((net.minecraft.client.gui.widget.Widget)new Button(this.field_230708_k_ / 2 - 155 + 160, this.field_230709_l_ / 4 + 132 + 12, 150, 20, NecLocalization.translatedText("notenoughcrashes.gui.getLink"), this::handleLegacyLinkClick));
        Button crashyButton = new Button(this.field_230708_k_ / 2 - 155 + 160, this.field_230709_l_ / 4 + 108 + 12, 150, 20, uploadToCrashyText, this::handleCrashyUploadClick);
        this.func_230480_a_((net.minecraft.client.gui.widget.Widget)crashyButton);
        this.x = this.field_230708_k_ / 2 - 155;
        this.y = this.field_230709_l_ / 4;
        this.addSuspectedModsWidget();
    }

    public boolean func_231044_a_(double x, double y, int int_1) {
        File file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.func_71497_f()) != null) {
            Util.func_110647_a().func_195641_a(file);
        }
        return super.func_231044_a_(x, y, int_1);
    }

    public boolean func_231178_ax__() {
        return false;
    }

    protected void drawFileNameString(MatrixStack matrixStack, int y) {
        String fileNameString = this.report.func_71497_f() != null ? "\u00a7n" + this.report.func_71497_f().getName() : NecLocalization.localize("notenoughcrashes.crashscreen.reportSaveFailed");
        int stLen = this.field_230712_o_.func_78256_a(fileNameString);
        this.xLeft = this.field_230708_k_ / 2 - stLen / 2;
        this.xRight = this.field_230708_k_ / 2 + stLen / 2;
        ProblemScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)fileNameString, (int)this.xLeft, (int)(y += 11), (int)65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.draw(matrixStack);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, delta);
    }
}

