/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class NecConfig {
    public boolean disableReturnToMainMenu = false;
    public boolean deobfuscateStackTrace = true;
    public boolean catchInitializationCrashes = true;
    public boolean debugModIdentification = false;
    public boolean forceCrashScreen = false;
    public int crashLimit = 20;
    public CrashUpload crashlogUpload = new CrashUpload();
    private static final File CONFIG_FILE = new File(NecPlatform.instance().getConfigDirectory().toFile(), "notenoughcrashes.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static NecConfig instance = null;

    public static NecConfig instance() {
        if (instance != null) {
            return instance;
        }
        if (CONFIG_FILE.exists()) {
            try {
                instance = (NecConfig)new Gson().fromJson((Reader)new FileReader(CONFIG_FILE), NecConfig.class);
                return instance;
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        instance = new NecConfig();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    public static class Pastebin {
        public String uploadKey = "";
        public Privacy privacy = Privacy.PUBLIC;
        public Expiry expiry = Expiry.NEVER;

        public static enum Expiry {
            NEVER("N"),
            TENMIN("10M"),
            ONEHOUR("1H"),
            ONEDAY("1D"),
            ONEWEEK("1W"),
            TWOWEEK("2W"),
            ONEMONTH("1M"),
            SIXMONTH("6M"),
            ONEYEAR("1Y");

            public final String pastebinExpiryKey;

            private Expiry(String pastebinExpiry) {
                this.pastebinExpiryKey = pastebinExpiry;
            }
        }

        public static enum Privacy {
            PUBLIC("0"),
            UNLISTED("1");

            public final String apiValue;

            private Privacy(String apiValue) {
                this.apiValue = apiValue;
            }
        }
    }

    public static class Gist {
        public String accessToken = "";
        public boolean unlisted = false;
    }

    public static enum CrashLogUploadDestination {
        GIST(3),
        HASTE(2),
        PASTEBIN(null),
        BYTEBIN(1),
        CRASHY(0);

        public final Integer defaultPriority;

        private CrashLogUploadDestination(Integer defaultPriority) {
            this.defaultPriority = defaultPriority;
        }
    }

    public static class CrashUpload {
        public CrashLogUploadDestination destination = CrashLogUploadDestination.BYTEBIN;
        public String hasteUrl = "https://hastebin.com/";
        public String bytebinUrl = "https://bytebin.lucko.me/";
        public Gist gist = new Gist();
        public Pastebin pastebin = new Pastebin();
        public String customUserAgent = "";
    }
}

