/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.sound;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public class Sounds {
    @SoundName(value="buried_treasure")
    public static SoundEvent BURIED_TREASURE = null;
    @SoundName(value="eastern_isles")
    public static SoundEvent EASTERN_ISLES = null;
    @SoundName(value="low_tide")
    public static SoundEvent LOW_TIDE = null;
    @SoundName(value="summering")
    public static SoundEvent SUMMERING = null;
    @SoundName(value="the_tribe")
    public static SoundEvent THE_TRIBE = null;
    @SoundName(value="trade_winds")
    public static SoundEvent TRADE_WINDS = null;
    @SoundName(value="page_flip")
    public static SoundEvent PAGE_FLIP = null;
    @SoundName(value="bongo.low")
    public static SoundEvent BONGO_LOW = null;
    @SoundName(value="bongo.medium")
    public static SoundEvent BONGO_MED = null;
    @SoundName(value="bongo.high")
    public static SoundEvent BONGO_HIGH = null;
    @SoundName(value="headlaughing")
    public static SoundEvent HEAD_LAUGHING = null;
    @SoundName(value="headattack")
    public static SoundEvent HEAD_ATTACK = null;
    @SoundName(value="headshort")
    public static SoundEvent HEAD_SHORT = null;
    @SoundName(value="headmed")
    public static SoundEvent HEAD_MED = null;
    @SoundName(value="headpain")
    public static SoundEvent HEAD_PAIN = null;
    @SoundName(value="headdeath")
    public static SoundEvent HEAD_DEATH = null;
    @SoundName(value="iggyattack")
    public static SoundEvent IGGY_ATTACK = null;
    @SoundName(value="iggydeath")
    public static SoundEvent IGGY_DEATH = null;
    @SoundName(value="iggyliving")
    public static SoundEvent IGGY_LIVING = null;
    @SoundName(value="ashen_laugh")
    public static SoundEvent ASHEN_LAUGH = null;
    @SoundName(value="dolphin")
    public static SoundEvent DOLPHIN = null;
    @SoundName(value="frogspit")
    public static SoundEvent FROG_SPIT = null;
    private static List<String> registeredSounds = new ArrayList<String>();

    private static SoundEvent register(String soundPath) {
        ResourceLocation resLoc = new ResourceLocation("tropicraft", soundPath);
        SoundEvent soundEvent = new SoundEvent(resLoc);
        ForgeRegistries.SOUND_EVENTS.register(soundEvent.setRegistryName(resLoc));
        if (registeredSounds.contains(soundPath)) {
            System.out.println("TCWARNING: duplicate sound registration for " + soundPath);
        }
        registeredSounds.add(soundPath);
        return soundEvent;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            for (Field f : Sounds.class.getDeclaredFields()) {
                if (!f.isAnnotationPresent(SoundName.class)) continue;
                try {
                    f.set(null, Sounds.register(f.getAnnotation(SoundName.class).value()));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SoundName {
        public String value();
    }
}

