/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tropicraft.core.common.block.tileentity.DrinkMixerTileEntity;
import net.tropicraft.core.common.network.message.MessageTileEntity;

public class MessageMixerInventory
extends MessageTileEntity<DrinkMixerTileEntity> {
    private NonNullList<ItemStack> inventory;
    private ItemStack result = ItemStack.field_190927_a;

    public MessageMixerInventory() {
    }

    public MessageMixerInventory(DrinkMixerTileEntity mixer) {
        super(mixer);
        this.inventory = mixer.ingredients;
        this.result = mixer.result;
    }

    public static void encode(MessageMixerInventory message, PacketBuffer buf) {
        MessageTileEntity.encode(message, buf);
        buf.writeByte(message.inventory.size());
        for (ItemStack i : message.inventory) {
            buf.func_150788_a(i);
        }
        buf.func_150788_a(message.result);
    }

    public static MessageMixerInventory decode(PacketBuffer buf) {
        MessageMixerInventory message = new MessageMixerInventory();
        MessageTileEntity.decode(message, buf);
        message.inventory = NonNullList.func_191197_a((int)buf.readByte(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < message.inventory.size(); ++i) {
            message.inventory.set(i, (Object)buf.func_150791_c());
        }
        message.result = buf.func_150791_c();
        return message;
    }

    public static void handle(MessageMixerInventory message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            DrinkMixerTileEntity mixer = (DrinkMixerTileEntity)message.getClientTileEntity();
            if (mixer != null) {
                mixer.ingredients = message.inventory;
                mixer.result = message.result;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

