/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.client.scuba.ScubaHUD;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaHarnessItem
extends ScubaArmorItem {
    public ScubaHarnessItem(ScubaType type, Item.Properties properties) {
        super(type, EquipmentSlotType.CHEST, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int airRemaining = this.getRemainingAir(stack);
        tooltip.add((ITextComponent)TropicraftLangKeys.SCUBA_AIR_TIME.format(new StringTextComponent(ScubaHUD.formatTime(airRemaining)).func_240699_a_(ScubaHUD.getAirTimeColor(airRemaining, worldIn))).func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public boolean providesAir() {
        return true;
    }

    @Override
    public void tickAir(PlayerEntity player, EquipmentSlotType slot, ItemStack stack) {
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return;
        }
        CompoundNBT scubaData = stack.func_190925_c("scuba");
        int remaining = this.getRemainingAir(stack);
        if (remaining > 0) {
            scubaData.func_74768_a("air", remaining - 1);
            player.func_70050_g(player.func_205010_bg());
        }
    }

    @Override
    public int addAir(int air, ItemStack stack) {
        if (air > 0) {
            int current = this.getRemainingAir(stack);
            int max = this.getMaxAir(stack);
            int newAir = Math.min(current + air, max);
            stack.func_190925_c("scuba").func_74768_a("air", newAir);
            return air - (newAir - current);
        }
        return 0;
    }

    @Override
    public int getRemainingAir(ItemStack stack) {
        return stack.func_190925_c("scuba").func_74762_e("air");
    }

    @Override
    public int getMaxAir(ItemStack stack) {
        return 12000;
    }

    public static void handleUnderwaterBreathing(TickEvent.PlayerTickEvent event) {
    }
}

