/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ScubaGogglesItem
extends ScubaArmorItem {
    private static final ResourceLocation GOGGLES_OVERLAY_TEX_PATH = new ResourceLocation("tropicraft", "textures/gui/goggles.png");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"tropicraft");
    private static final RegistryObject<Attribute> UNDERWATER_VISIBILITY = ATTRIBUTES.register("underwater_visibility", () -> new RangedAttribute(TropicraftLangKeys.SCUBA_VISIBILITY_STAT.getKey(), 0.0, -1.0, 1.0));
    private static final AttributeModifier VISIBILITY_BOOST = new AttributeModifier(UUID.fromString("b09a907f-8264-455b-af81-997c06aa2268"), "tropicraft.underwater.visibility", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
    private final LazyValue<Multimap<Attribute, AttributeModifier>> boostedModifiers = new LazyValue(() -> ImmutableMultimap.builder().putAll(super.getAttributeModifiers(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)this))).put((Object)UNDERWATER_VISIBILITY.get(), (Object)VISIBILITY_BOOST).build());

    public ScubaGogglesItem(ScubaType type, Item.Properties builder) {
        super(type, EquipmentSlotType.HEAD, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, PlayerEntity player, int width, int height, float partialTicks) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        Minecraft mc = Minecraft.func_71410_x();
        double scaledWidth = mc.func_228018_at_().func_198107_o();
        double scaledHeight = mc.func_228018_at_().func_198087_p();
        mc.func_110434_K().func_110577_a(GOGGLES_OVERLAY_TEX_PATH);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, scaledHeight, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(scaledWidth, scaledHeight, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(scaledWidth, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderWaterFog(EntityViewRenderEvent.FogDensity event) {
        ClientPlayerEntity player;
        ActiveRenderInfo info = event.getInfo();
        FluidState fluid = info.func_216771_k();
        if (fluid.func_206884_a((ITag)FluidTags.field_206959_a) && info.func_216773_g() instanceof ClientPlayerEntity && (player = (ClientPlayerEntity)info.func_216773_g()).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ScubaGogglesItem) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            float f = 0.05f - player.func_203719_J() * player.func_203719_J() * 0.03f;
            event.setDensity(f *= 0.75f);
            event.setCanceled(true);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (slot == EquipmentSlotType.HEAD) {
            return (Multimap)this.boostedModifiers.func_179281_c();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

