/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.fml.RegistryObject;

public class TropicraftSpawnEgg<T extends Entity>
extends Item {
    private final RegistryObject<EntityType<T>> typeIn;

    public TropicraftSpawnEgg(RegistryObject<EntityType<T>> type, Item.Properties properties) {
        super(properties);
        this.typeIn = type;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity te;
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemStack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction dir = context.func_196000_l();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150474_ac && (te = world.func_175625_s(pos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner spawner = ((MobSpawnerTileEntity)te).func_145881_a();
            EntityType spawnType = (EntityType)this.typeIn.get();
            spawner.func_200876_a(spawnType);
            te.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            itemStack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        BlockPos spawnPos = state.func_196952_d((IBlockReader)world, pos).func_197766_b() ? pos : pos.func_177972_a(dir);
        EntityType type3 = (EntityType)this.typeIn.get();
        if (type3.func_220331_a((ServerWorld)world, itemStack, context.func_195999_j(), spawnPos, SpawnReason.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && dir == Direction.UP) != null) {
            itemStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        BlockRayTraceResult rayTraceResult = TropicraftSpawnEgg.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        BlockRayTraceResult traceResult = rayTraceResult;
        BlockPos tracePos = traceResult.func_216350_a();
        if (!(world.func_180495_p(tracePos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        if (world.func_175660_a(player, tracePos) && player.func_175151_a(tracePos, traceResult.func_216354_b(), heldItem)) {
            EntityType type = (EntityType)this.typeIn.get();
            if (type.func_220331_a((ServerWorld)world, heldItem, player, tracePos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)heldItem);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }
}

