/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tropicraft.Constants;
import net.tropicraft.core.common.item.IColoredItem;
import net.tropicraft.core.common.item.ShellItem;
import org.apache.commons.lang3.ArrayUtils;

public class LoveTropicsShellItem
extends ShellItem
implements IColoredItem {
    public LoveTropicsShellItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getColor(ItemStack itemstack, int pass) {
        CompoundNBT tag = itemstack.func_77978_p();
        if (tag != null && !tag.isEmpty() && tag.func_74764_b("Name")) {
            return pass == 0 ? -1 : (Integer)LTUtil.colors.get(tag.func_74779_i("Name"));
        }
        return pass == 0 ? -1 : (Integer)LTUtil.colors.get(Constants.LT17_NAMES[0]);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Name")) {
            return super.func_200295_i(stack);
        }
        String name = stack.func_77978_p().func_74779_i("Name");
        String type = name.endsWith("s") ? "with_s" : "normal";
        return new TranslationTextComponent("item.tropicraft.shell.owned." + type, new Object[]{name});
    }

    public static class LTUtil {
        private static final Map<String, Integer> colors = Maps.newHashMap();
        private static final Random rand = new Random();

        static {
            for (String name : (String[])ArrayUtils.addAll((Object[])Constants.LT17_NAMES, (Object[])Constants.LT18_NAMES)) {
                rand.setSeed(name.hashCode());
                colors.put(name, Color.HSBtoRGB(rand.nextFloat(), rand.nextFloat() * 0.2f + 0.7f, 1.0f));
            }
        }
    }
}

