/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.drinks.ColorMixer;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.IColoredItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class CocktailItem
extends Item
implements IColoredItem {
    private static final int DEFAULT_COLOR = 15973942;
    private final Drink drink;

    public CocktailItem(Drink drink, Item.Properties properties) {
        super(properties);
        this.drink = drink;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Drink drink = CocktailItem.getDrink(stack);
        if (drink == Drink.COCKTAIL && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Ingredients")) {
            ListNBT ingredients = stack.func_77978_p().func_150295_c("Ingredients", 10);
            for (int i = 0; i < ingredients.size(); ++i) {
                CompoundNBT ingredient = ingredients.func_150305_b(i);
                byte id = ingredient.func_74771_c("IngredientID");
                ITextComponent ingredientName = Ingredient.ingredientsList[id].getDisplayName();
                int ingredientColor = Ingredient.ingredientsList[id].getColor();
                tooltip.add(ingredientName);
            }
        }
    }

    public static int getCocktailColor(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && !tag.isEmpty() && tag.func_74764_b("Color")) {
            return tag.func_74762_e("Color");
        }
        return 15973942;
    }

    @Nonnull
    public static ItemStack makeCocktail(MixerRecipe recipe) {
        ItemStack stack = MixerRecipes.getItemStack(recipe.getCraftingResult());
        CompoundNBT nbt = new CompoundNBT();
        Drink drink = recipe.getCraftingResult();
        nbt.func_74774_a("DrinkID", (byte)drink.drinkId);
        ListNBT tagList = new ListNBT();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            CompoundNBT ingredientNbt = new CompoundNBT();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.id);
            tagList.add((Object)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_218657_a("Ingredients", (INBT)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public static ItemStack makeCocktail(NonNullList<ItemStack> itemStacks) {
        ItemStack stack = new ItemStack((IItemProvider)((RegistryObject)TropicraftItems.COCKTAILS.get((Object)Drink.COCKTAIL)).get());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74774_a("DrinkID", (byte)Drink.COCKTAIL.drinkId);
        ListNBT tagList = new ListNBT();
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (ItemStack ingredientStack : itemStacks) {
            ingredients.addAll(Ingredient.listIngredients(ingredientStack));
        }
        Collections.sort(ingredients);
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            CompoundNBT ingredientNbt = new CompoundNBT();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.id);
            tagList.add((Object)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_218657_a("Ingredients", (INBT)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static Ingredient[] getIngredients(ItemStack stack) {
        if (!Drink.isDrink(stack.func_77973_b()) || !stack.func_77942_o()) {
            return new Ingredient[0];
        }
        CompoundNBT nbt = stack.func_77978_p();
        ListNBT tagList = nbt.func_150295_c("Ingredients", 10);
        Ingredient[] ingredients = new Ingredient[tagList.size()];
        for (int i = 0; i < tagList.size(); ++i) {
            byte ingredientID = tagList.func_150305_b(i).func_74771_c("IngredientID");
            ingredients[i] = Ingredient.ingredientsList[ingredientID];
        }
        return ingredients;
    }

    @Nullable
    public static Drink getDrink(ItemStack stack) {
        if (!Drink.isDrink(stack.func_77973_b())) {
            return null;
        }
        return ((CocktailItem)stack.func_77973_b()).drink;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ItemStack onFoodEaten(ItemStack itemstack, World world, PlayerEntity player) {
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        for (Ingredient ingredient : CocktailItem.getIngredients(itemstack)) {
            ingredient.onDrink(player);
        }
        Drink drink = CocktailItem.getDrink(itemstack);
        if (drink != null) {
            drink.onDrink(player);
        }
        return new ItemStack((IItemProvider)TropicraftItems.BAMBOO_MUG.get());
    }

    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            this.onFoodEaten(stack, worldIn, player);
            Drink drink = CocktailItem.getDrink(stack);
            if (!worldIn.func_175727_C(player.func_233580_cy_()) || drink == Drink.PINA_COLADA) {
                // empty if block
            }
        }
        return new ItemStack((IItemProvider)TropicraftItems.BAMBOO_MUG.get());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Drink drink = CocktailItem.getDrink(stack);
        if (drink == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public int getColor(ItemStack itemstack, int tintIndex) {
        Drink drink = CocktailItem.getDrink(itemstack);
        return tintIndex == 0 || drink == null ? 0xFFFFFF : drink.color;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Drink drink = CocktailItem.getDrink(stack);
        if (drink != null) {
            return super.func_200295_i(stack).func_230532_e_().func_240699_a_(drink.textFormatting).func_240699_a_(TextFormatting.BOLD);
        }
        return super.func_200295_i(stack);
    }

    public Drink getDrink() {
        return this.drink;
    }
}

