/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class BlowGunItem
extends ShootableItem {
    public BlowGunItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> func_220004_b() {
        return itemStack -> {
            if (itemStack.func_77973_b() == Items.field_185167_i) {
                for (EffectInstance effectInstance : PotionUtils.func_185189_a((ItemStack)itemStack)) {
                    if (effectInstance.func_188419_a() != Effects.field_76421_d) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public int func_230305_d_() {
        return 8;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        ItemStack ammo = BlowGunItem.getAmmo((LivingEntity)player, heldStack);
        if (!ammo.func_190926_b()) {
            BlowGunItem.fireProjectile(world, (LivingEntity)player, hand, heldStack, ammo, 1.0f, player.field_71075_bZ.field_75098_d, 10.0f, 0.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldStack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
    }

    private static ItemStack getAmmo(LivingEntity entityIn, ItemStack stack) {
        boolean isCreativeMode = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack ammo = entityIn.func_213356_f(stack);
        if (isCreativeMode) {
            return BlowGunItem.getProjectile();
        }
        if (!ammo.func_190926_b()) {
            return ammo;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getProjectile() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_185167_i);
        itemStack = PotionUtils.func_185184_a((ItemStack)itemStack, (Collection)ImmutableList.of((Object)new EffectInstance(Effects.field_76421_d, 60, 20)));
        return itemStack;
    }

    public static void fireProjectile(World world, LivingEntity shooter, Hand hand, ItemStack heldItem, ItemStack projectile, float soundPitch, boolean isCreativeMode, float dmg, float pitch) {
        if (!world.field_72995_K) {
            ArrowEntity arrowEntity = BlowGunItem.createArrow(world, shooter, projectile);
            if (isCreativeMode) {
                arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            }
            Vector3d lookVec = shooter.func_70040_Z();
            Quaternion quaternion = new Quaternion(new Vector3f(lookVec), 0.0f, true);
            Vector3d look = shooter.func_70676_i(1.0f);
            Vector3f look3f = new Vector3f(look);
            look3f.func_214905_a(quaternion);
            arrowEntity.func_70186_c((double)look3f.func_195899_a(), (double)look3f.func_195900_b(), (double)look3f.func_195902_c(), dmg, pitch);
            heldItem.func_222118_a(1, shooter, i -> i.func_213334_d(hand));
            projectile.func_77979_a(1);
            if (projectile.func_190926_b() && shooter instanceof PlayerEntity) {
                ((PlayerEntity)shooter).field_71071_by.func_184437_d(projectile);
            }
            world.func_217376_c((Entity)arrowEntity);
            world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    public static ArrowEntity createArrow(World world, LivingEntity shooter, ItemStack projectile) {
        ArrowItem arrowItem = (ArrowItem)(projectile.func_77973_b() instanceof ArrowItem ? projectile.func_77973_b() : Items.field_151032_g);
        ArrowEntity arrowEntity = (ArrowEntity)arrowItem.func_200887_a(world, projectile, shooter);
        arrowEntity.func_70239_b(0.0);
        arrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        arrowEntity.func_70243_d(false);
        arrowEntity.func_184555_a(BlowGunItem.getProjectile());
        return arrowEntity;
    }
}

