/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftTropicalFishEntity
extends AbstractGroupFishEntity
implements IAtlasFish {
    private static final DataParameter<Byte> DATA_FISH_TYPE = EntityDataManager.func_187226_a(TropicraftTropicalFishEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public TropicraftTropicalFishEntity(EntityType<? extends AbstractGroupFishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return AbstractGroupFishEntity.func_234176_m_().func_233815_a_(Attributes.field_233818_a_, 5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FISH_TYPE, (Object)0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT nbt) {
        entityData = super.func_213386_a(world, difficultyInstance, spawnReason, entityData, nbt);
        if (nbt != null && nbt.func_150297_b("BucketVariantTag", 3)) {
            this.setFishType(FishType.getById(nbt.func_74762_e("BucketVariantTag")));
        } else {
            this.setFishType(FishType.getRandomType(this.field_70146_Z));
        }
        return entityData;
    }

    public FishType getFishType() {
        return FishType.VALUES[(Byte)this.field_70180_af.func_187225_a(DATA_FISH_TYPE)];
    }

    public void setFishType(FishType type) {
        this.field_70180_af.func_187227_b(DATA_FISH_TYPE, (Object)((byte)type.ordinal()));
    }

    public int func_203704_dv() {
        return 24;
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)TropicraftItems.TROPICAL_FISH_BUCKET.get());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203820_gM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203821_gN;
    }

    protected SoundEvent func_184601_bQ(DamageSource dmgSrc) {
        return SoundEvents.field_203823_gP;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203822_gO;
    }

    @Override
    public int getAtlasSlot() {
        return this.getFishType().ordinal();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.TROPICAL_FISH_SPAWN_EGG.get());
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == TropicraftItems.FISHING_NET.get()) {
            boolean firstHotbarSlot = false;
            int bucketSlot = -1;
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                ItemStack s = player.field_71071_by.func_70301_a(0 + i);
                if (!this.isFishHolder(s)) continue;
                bucketSlot = 0 + i;
                break;
            }
            if (bucketSlot == -1 && this.isFishHolder(player.func_184592_cb())) {
                bucketSlot = 36;
            }
            if (bucketSlot >= 0) {
                ItemStack fishHolder = player.field_71071_by.func_70301_a(bucketSlot);
                if (fishHolder.func_77973_b() == Items.field_151131_as) {
                    fishHolder = new ItemStack((IItemProvider)TropicraftItems.TROPICAL_FISH_BUCKET.get());
                    player.field_71071_by.func_70299_a(bucketSlot, fishHolder);
                }
                this.func_204211_f(fishHolder);
                player.func_184609_a(hand);
                this.field_70170_p.func_184133_a(player, this.func_233580_cy_(), SoundEvents.field_187549_bG, SoundCategory.PLAYERS, 0.25f, 1.0f + this.field_70146_Z.nextFloat() * 0.4f);
                this.func_70106_y();
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("FishType", this.getFishType().id);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFishType(FishType.getById(compound.func_74762_e("FishType")));
    }

    protected void func_204211_f(ItemStack bucket) {
        super.func_204211_f(bucket);
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("BucketVariantTag", this.getFishType().id);
    }

    private boolean isFishHolder(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == Items.field_151131_as || stack.func_77973_b() == TropicraftItems.TROPICAL_FISH_BUCKET.get());
    }

    static enum FishType {
        CLOWNFISH(0),
        QUEEN_ANGELFISH(1),
        YELLOW_TANG(2),
        BUTTERFLY_FISH(3),
        GEOPHAGUS_SURINAMENSIS(4),
        BETTA_FISH(5),
        REGAL_TANG(6),
        ROYAL_GAMMA(7);

        public static final FishType[] VALUES;
        private final int id;

        private FishType(int id) {
            this.id = id;
        }

        private static FishType getById(int id) {
            for (FishType type : VALUES) {
                if (type.id != id) continue;
                return type;
            }
            return CLOWNFISH;
        }

        private static FishType getRandomType(Random rand) {
            return VALUES[rand.nextInt(FishType.values().length)];
        }

        static {
            VALUES = FishType.values();
        }
    }
}

