/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.TropicraftItems;

public class ManOWarEntity
extends WaterMobEntity {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;
    private int attackTimer = 0;

    public ManOWarEntity(EntityType<? extends ManOWarEntity> type, World world) {
        super(type, world);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70728_aV = 7;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveRandomGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeGoal());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return WaterMobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b * 0.5f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public LivingEntity func_70638_az() {
        return null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.func_203005_aq()) {
            if (this.field_70146_Z.nextInt(5) == 0 && this.attackTimer <= 0) {
                List list = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(2.0, 4.0, 2.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d);
                for (LivingEntity ent : list) {
                    if (ent.func_200600_R() == TropicraftEntities.MAN_O_WAR.get() || !ent.func_70090_H()) continue;
                    ent.func_70097_a(DamageSource.field_180137_b, (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                    this.attackTimer = 20;
                }
            }
            if (this.squidRotation < (float)Math.PI) {
                float lvt_1_1_ = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(lvt_1_1_ * lvt_1_1_ * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)lvt_1_1_ > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vector3d motion = this.func_213322_ci();
            float lvt_2_1_ = MathHelper.func_76133_a((double)ManOWarEntity.func_213296_b((Vector3d)motion));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)lvt_2_1_, (double)motion.field_72448_b)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double lvt_1_3_ = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    lvt_1_3_ = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    lvt_1_3_ -= 0.08;
                }
                this.func_213293_j(0.0, lvt_1_3_ * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    public int func_70627_aG() {
        return 120;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    public void func_213352_e(Vector3d vector) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.MAN_O_WAR_SPAWN_EGG.get());
    }

    static class MoveRandomGoal
    extends Goal {
        private final ManOWarEntity manOWarEntity;

        public MoveRandomGoal(ManOWarEntity p_i48823_2_) {
            this.manOWarEntity = p_i48823_2_;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int lvt_1_1_ = this.manOWarEntity.func_70654_ax();
            if (lvt_1_1_ > 100) {
                this.manOWarEntity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.manOWarEntity.func_70681_au().nextInt(50) == 0 || !this.manOWarEntity.func_70090_H() || !this.manOWarEntity.hasMovementVector()) {
                float lvt_2_1_ = this.manOWarEntity.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float lvt_3_1_ = MathHelper.func_76134_b((float)lvt_2_1_) * 0.2f;
                float lvt_4_1_ = -0.1f + this.manOWarEntity.func_70681_au().nextFloat() * 0.2f;
                float lvt_5_1_ = MathHelper.func_76126_a((float)lvt_2_1_) * 0.2f;
                this.manOWarEntity.setMovementVector(lvt_3_1_, lvt_4_1_, lvt_5_1_);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int tickCounter;

        private FleeGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity lvt_1_1_ = ManOWarEntity.this.func_70643_av();
            if (ManOWarEntity.this.func_70090_H() && lvt_1_1_ != null) {
                return ManOWarEntity.this.func_70068_e((Entity)lvt_1_1_) < 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = 0;
        }

        public void func_75246_d() {
            ++this.tickCounter;
            LivingEntity target = ManOWarEntity.this.func_70643_av();
            if (target != null) {
                Vector3d lvt_2_1_ = new Vector3d(ManOWarEntity.this.func_226277_ct_() - target.func_226277_ct_(), ManOWarEntity.this.func_226278_cu_() - target.func_226278_cu_(), ManOWarEntity.this.func_226281_cx_() - target.func_226281_cx_());
                BlockState block = ManOWarEntity.this.field_70170_p.func_180495_p(new BlockPos(ManOWarEntity.this.func_226277_ct_() + lvt_2_1_.field_72450_a, ManOWarEntity.this.func_226278_cu_() + lvt_2_1_.field_72448_b, ManOWarEntity.this.func_226281_cx_() + lvt_2_1_.field_72449_c));
                FluidState fluid = ManOWarEntity.this.field_70170_p.func_204610_c(new BlockPos(ManOWarEntity.this.func_226277_ct_() + lvt_2_1_.field_72450_a, ManOWarEntity.this.func_226278_cu_() + lvt_2_1_.field_72448_b, ManOWarEntity.this.func_226281_cx_() + lvt_2_1_.field_72449_c));
                if (fluid.func_206884_a((ITag)FluidTags.field_206959_a) || block.func_196958_f()) {
                    double lvt_5_1_ = lvt_2_1_.func_72433_c();
                    if (lvt_5_1_ > 0.0) {
                        lvt_2_1_.func_72432_b();
                        float lvt_7_1_ = 3.0f;
                        if (lvt_5_1_ > 5.0) {
                            lvt_7_1_ = (float)((double)lvt_7_1_ - (lvt_5_1_ - 5.0) / 5.0);
                        }
                        if (lvt_7_1_ > 0.0f) {
                            lvt_2_1_ = lvt_2_1_.func_186678_a((double)lvt_7_1_);
                        }
                    }
                    if (block.func_196958_f()) {
                        lvt_2_1_ = lvt_2_1_.func_178786_a(0.0, lvt_2_1_.field_72448_b, 0.0);
                    }
                    ManOWarEntity.this.setMovementVector((float)lvt_2_1_.field_72450_a / 20.0f, (float)lvt_2_1_.field_72448_b / 20.0f, (float)lvt_2_1_.field_72449_c / 20.0f);
                }
                if (this.tickCounter % 10 == 5) {
                    ManOWarEntity.this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, ManOWarEntity.this.func_226277_ct_(), ManOWarEntity.this.func_226278_cu_(), ManOWarEntity.this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

