/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.egg.EggEntity;

public abstract class EchinodermEntity
extends WaterMobEntity {
    public static final int GROWTH_TICKS = 12000;
    public static final int BREEDING_COOLDOWN = 12000;
    public static final int BREEDING_PROXIMITY = 4;
    public static final int MAX_NEIGHBORS = 6;
    public static final int NEIGHBORHOOD_SIZE = 8;
    public static final int MATE_SCAN_INTERVAL = 100;
    private int prevGrowingAge;
    private int mateScanCooldown;
    private static final DataParameter<Integer> GROWING_AGE = EntityDataManager.func_187226_a(EchinodermEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private double yOffset = -1.0;

    public EchinodermEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
        this.setEchinodermSize();
    }

    public void setBaby() {
        this.setGrowingAge(-12000);
        this.setEchinodermSize();
    }

    public abstract EggEntity createEgg();

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROWING_AGE, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setGrowingAge(compound.func_74762_e("Age"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Age", this.getGrowingAge());
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public boolean isHorny() {
        return this.getGrowingAge() == 0;
    }

    private EchinodermEntity findMate() {
        int neighbors = 0;
        EchinodermEntity closestMate = null;
        double closestSqDist = -1.0;
        AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0);
        for (Object obj : this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), aabb)) {
            double sqDist;
            if (obj == this) continue;
            ++neighbors;
            EchinodermEntity other = (EchinodermEntity)((Object)obj);
            if (!this.isPotentialMate(other) || !((sqDist = this.func_70068_e((Entity)other)) < 4.0) || closestSqDist != -1.0 && !(sqDist < closestSqDist)) continue;
            closestMate = other;
            closestSqDist = sqDist;
        }
        if (neighbors > 6) {
            return null;
        }
        return closestMate;
    }

    public boolean isPotentialMate(EchinodermEntity other) {
        return !other.func_70631_g_() && other.isHorny();
    }

    public int getGrowingAge() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(GROWING_AGE, (Object)age);
    }

    public float getGrowthProgress() {
        int growingAge = this.getGrowingAge();
        return growingAge < 0 ? 1.0f + (float)growingAge / 12000.0f : 1.0f;
    }

    private void setEchinodermSize() {
        float growthProgress = this.getGrowthProgress();
        float width = this.getBabyWidth() + growthProgress * (this.getAdultWidth() - this.getBabyWidth());
        float height = this.getBabyHeight() + growthProgress * (this.getAdultHeight() - this.getBabyHeight());
        float yO = this.getBabyYOffset() + growthProgress * (this.getAdultYOffset() - this.getBabyYOffset());
        this.func_213323_x_();
        this.yOffset = yO;
    }

    public double func_70033_W() {
        if (this.yOffset < 0.0) {
            return super.func_70033_W();
        }
        return this.yOffset;
    }

    public abstract float getBabyWidth();

    public abstract float getAdultWidth();

    public abstract float getBabyHeight();

    public abstract float getAdultHeight();

    public abstract float getBabyYOffset();

    public abstract float getAdultYOffset();
}

