/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class BeachFloatEntity
extends FurnitureEntity
implements IEntityAdditionalSpawnData {
    @Nonnull
    private static final Random rand = new Random(298457L);
    @Nonnull
    private static final PerlinNoiseGenerator windNoise = new PerlinNoiseGenerator(new SharedSeedRandom(298457L), (List)ImmutableList.of((Object)0));
    private double windModifier = 0.0;
    public boolean isEmpty;
    public float rotationSpeed;
    private double prevMotionY;

    public BeachFloatEntity(EntityType<BeachFloatEntity> type, World worldIn) {
        super(type, worldIn, TropicraftItems.BEACH_FLOATS);
        this.field_70158_ak = true;
        this.isEmpty = true;
        this.field_70156_m = true;
        this.field_70144_Y = 0.95f;
        this.func_145769_d(this.func_145782_y());
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        rand.setSeed(id);
        this.windModifier = 1.0 + rand.nextGaussian() * 0.1 - 0.05;
    }

    @Override
    public void func_70071_h_() {
        double eps;
        double center;
        double water;
        Entity rider = this.func_184179_bs();
        if (this.field_70170_p.field_72995_K && rider instanceof PlayerEntity) {
            PlayerEntity controller = (PlayerEntity)rider;
            float move = controller.field_191988_bg;
            float rot = -controller.field_70702_br;
            this.rotationSpeed += rot * 0.25f;
            float ang = this.field_70177_z;
            float moveX = MathHelper.func_76126_a((float)(-ang * ((float)Math.PI / 180))) * move * 0.0035f;
            float moveZ = MathHelper.func_76134_b((float)(ang * ((float)Math.PI / 180))) * move * 0.0035f;
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)moveX, 0.0, (double)moveZ));
        }
        if (this.field_70171_ac) {
            double windAng = (windNoise.func_215464_a(this.func_226277_ct_() / 1000.0, this.func_226281_cx_() / 1000.0, false) + 1.0) * Math.PI;
            double windX = Math.sin(windAng) * 5.0E-4 * this.windModifier;
            double windZ = Math.cos(windAng) * 5.0E-4 * this.windModifier;
            this.func_213317_d(this.func_213322_ci().func_72441_c(windX, 0.0, windZ));
            double targetYaw = Math.toDegrees(windAng) + (this.windModifier - 1.0) * 45.0;
            double yaw = (MathHelper.func_76142_g((float)this.field_70177_z) + 180.0f - 35.0f) % 360.0f;
            double angleDiff = targetYaw - yaw;
            this.rotationSpeed = angleDiff > 0.0 ? (float)((double)this.rotationSpeed + Math.min(0.005 * this.windModifier, angleDiff)) : (float)((double)this.rotationSpeed + Math.max(-0.005 * this.windModifier, angleDiff));
        }
        if ((water = (double)this.getWaterLevel()) < (center = this.getCenterY()) - (eps = 0.0625)) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -MathHelper.func_151237_a((double)(center - water), (double)0.0, (double)0.04), 0.0));
        } else if (water > center + eps) {
            double floatpush = MathHelper.func_151237_a((double)(water - center), (double)0.0, (double)0.02);
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, floatpush, 0.0));
        } else if (Math.abs(this.func_213322_ci().field_72448_b) < 0.02) {
            if (this.func_213322_ci().field_72448_b != 0.0) {
                this.lerpY = water - 0.011;
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.prevMotionY = 0.0;
        }
        super.func_70071_h_();
        this.field_70177_z += this.rotationSpeed;
        this.func_213315_a(MoverType.PLAYER, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.9, 0.9, 0.9));
        this.rotationSpeed *= 0.9f;
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f));
            for (Entity entity : list) {
                if (entity == this.func_184179_bs() || !entity.func_70104_M()) continue;
                entity.func_70108_f((Entity)this);
            }
            if (this.func_184179_bs() != null && !this.func_184179_bs().func_70089_S()) {
                this.func_184226_ay();
            }
        }
    }

    @Override
    protected boolean preventMotion() {
        return false;
    }

    private double getCenterY() {
        AxisAlignedBB bb = this.func_174813_aQ();
        return bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * 0.5;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.prevMotionY = this.func_213322_ci().field_72448_b;
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    protected boolean func_233566_aG_() {
        this.field_233554_M_.clear();
        this.func_233567_aH_();
        boolean lava = this.func_210500_b((ITag)FluidTags.field_206960_b, this.field_70170_p.func_230315_m_().func_236040_e_() ? 0.007 : 0.0023333333333333335);
        return this.func_70090_H() || lava;
    }

    void func_233567_aH_() {
        AxisAlignedBB temp = this.func_174813_aQ();
        this.func_174826_a(temp.func_191195_a(1.0, 0.0, 1.0).func_191195_a(-1.0, 0.125, -1.0));
        try {
            if (this.func_210500_b((ITag)FluidTags.field_206959_a, 0.014)) {
                if (!this.field_70171_ac && !this.field_70148_d) {
                    this.func_71061_d_();
                }
                this.field_70143_R = 0.0f;
                this.field_70171_ac = true;
                this.func_70066_B();
            } else {
                this.field_70171_ac = false;
            }
        }
        finally {
            this.func_174826_a(temp);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_225608_bj_()) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return !player.func_184223_x((Entity)this) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((!this.func_70089_S() ? 0.001 : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof LivingEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            float len = 0.6f;
            double x = this.func_226277_ct_() + (double)(-MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * len);
            double z = this.func_226281_cx_() + (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * len);
            passenger.func_70107_b(x, this.func_226278_cu_() + (double)f1, z);
            passenger.field_70177_z += this.rotationSpeed;
            passenger.func_70034_d(passenger.func_70079_am() + this.rotationSpeed);
            this.applyYawToEntity(passenger);
            if (passenger instanceof LivingEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((LivingEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
            if (passenger instanceof PlayerEntity) {
                ((PlayerEntity)passenger).func_174826_a(this.func_174813_aQ().func_72321_a(0.0, 0.3, 0.0).func_191195_a(0.0, -0.1875, 0.0));
            }
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (passenger instanceof PlayerEntity) {
            passenger.func_213323_x_();
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        if (!entityToUpdate.field_70170_p.field_72995_K || BeachFloatEntity.isClientFirstPerson(entityToUpdate)) {
            entityToUpdate.func_181013_g(this.field_70177_z);
            float yaw = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
            float pitch = MathHelper.func_76142_g((float)(entityToUpdate.field_70125_A - this.field_70125_A));
            float clampedYaw = MathHelper.func_76131_a((float)yaw, (float)-105.0f, (float)105.0f);
            float clampedPitch = MathHelper.func_76131_a((float)pitch, (float)-100.0f, (float)-10.0f);
            entityToUpdate.field_70126_B += clampedYaw - yaw;
            entityToUpdate.field_70177_z += clampedYaw - yaw;
            entityToUpdate.field_70127_C += clampedPitch - pitch;
            entityToUpdate.field_70125_A += clampedPitch - pitch;
            entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
        }
    }

    public void func_184190_l(@Nonnull Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    private static boolean isClientFirstPerson(Entity entity) {
        Minecraft client = Minecraft.func_71410_x();
        return client.field_175622_Z == entity && client.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON;
    }

    private float getWaterLevel() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int minY = MathHelper.func_76128_c((double)(axisalignedbb.field_72338_b - this.prevMotionY));
        int maxY = minY + 1;
        int minZ = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        float waterHeight = minY - 1;
        for (int y = maxY; y >= minY; --y) {
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.func_181079_c(x, y, z);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)pos);
                    if (fluidstate.func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a)) {
                        waterHeight = Math.max(waterHeight, (float)pos.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)pos));
                    }
                    if (!(waterHeight >= (float)maxY)) continue;
                    return waterHeight;
                }
            }
        }
        return waterHeight;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    public double func_70033_W() {
        return 0.0;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213302_cg() - 1.1;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.lerpYaw);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.lerpYaw = MathHelper.func_76138_g((double)additionalData.readDouble());
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.BEACH_FLOATS.get(DyeColor.func_196056_a((int)this.getColor().func_196059_a())).get());
    }
}

