/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.monkey;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.item.TropicraftItems;

public class SpiderMonkeyEntity
extends AnimalEntity {
    private static final Supplier<Ingredient> BREEDING_ITEMS = Suppliers.memoize(() -> Ingredient.func_199805_a(TropicraftTags.Items.FRUITS));
    private static final int STAND_ANIMATION_LENGTH = 15;
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(SpiderMonkeyEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int standAnimation;

    public SpiderMonkeyEntity(EntityType<? extends SpiderMonkeyEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, BREEDING_ITEMS.get(), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.tickStandingState();
        } else {
            this.tickStandingAnimation();
        }
    }

    private void tickStandingState() {
        if (this.func_70643_av() != null) {
            this.setStanding(false);
            return;
        }
        if (this.field_70170_p.field_73012_v.nextInt(200) == 0) {
            boolean standing = this.field_70170_p.field_73012_v.nextInt(3) == 0;
            this.setStanding(standing);
        }
    }

    private void tickStandingAnimation() {
        if (this.isStanding()) {
            if (this.standAnimation < 15) {
                ++this.standAnimation;
            }
        } else if (this.standAnimation > 0) {
            --this.standAnimation;
        }
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
        this.standAnimation = standing ? 15 : 0;
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public float getStandAnimation(float partialTicks) {
        float animation = ((float)this.standAnimation + (this.isStanding() ? partialTicks : -partialTicks)) / 15.0f;
        return Easings.inOutSine(MathHelper.func_76131_a((float)animation, (float)0.0f, (float)1.0f));
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setStanding(nbt.func_74767_n("standing"));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("standing", this.isStanding());
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public SpiderMonkeyEntity createChild(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.SPIDER_MONKEY_SPAWN_EGG.get());
    }

    public int func_82143_as() {
        return 5;
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return super.func_225508_e_(distance, damageMultiplier) / 2;
    }
}

