/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.basilisk;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class WaterWalking {
    private static final double HEIGHT = 0.875;
    public static final VoxelShape COLLIDER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public static boolean canWalkOn(FluidState fluid) {
        return !fluid.func_206888_e() && WaterWalking.canWalkOn(fluid.func_206886_c()) && fluid.func_206882_g() == 8;
    }

    public static boolean canWalkOn(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public static Vector3d collide(IBlockReader world, AxisAlignedBB box, Vector3d offset) {
        if (offset.func_189985_c() == 0.0 || offset.field_72448_b >= 0.0) {
            return offset;
        }
        Stream<VoxelShape> collisions = WaterWalking.collisions(world, box.func_216361_a(offset));
        double dy = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)box, collisions, (double)offset.field_72448_b);
        return new Vector3d(offset.field_72450_a, dy, offset.field_72449_c);
    }

    public static Stream<VoxelShape> collisions(IBlockReader world, AxisAlignedBB box) {
        int x0 = MathHelper.func_76128_c((double)box.field_72340_a);
        int x1 = MathHelper.func_76128_c((double)box.field_72336_d);
        int y0 = MathHelper.func_76128_c((double)box.field_72338_b);
        int y1 = MathHelper.func_76128_c((double)box.field_72337_e);
        int z0 = MathHelper.func_76128_c((double)box.field_72339_c);
        int z1 = MathHelper.func_76128_c((double)box.field_72334_f);
        CubeCoordinateIterator iterator = new CubeCoordinateIterator(x0, y0, z0, x1, y1, z1);
        CollisionSpliterator spliterator = new CollisionSpliterator(world, box, iterator);
        return StreamSupport.stream(spliterator, false);
    }

    public static final class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity entity, World world) {
            super(entity, world);
            this.func_212239_d(true);
        }

        protected PathFinder func_179679_a(int depth) {
            this.field_179695_a = new WalkNodeProcessor();
            return new PathFinder(this.field_179695_a, depth);
        }

        protected boolean func_230287_a_(PathNodeType type) {
            return type == PathNodeType.WATER || type == PathNodeType.WATER_BORDER || super.func_230287_a_(type);
        }

        public boolean func_188555_b(BlockPos pos) {
            return WaterWalking.canWalkOn(this.field_75513_b.func_204610_c(pos)) || super.func_188555_b(pos);
        }
    }

    public static final class CollisionSpliterator
    extends Spliterators.AbstractSpliterator<VoxelShape> {
        private final IBlockReader world;
        private final AxisAlignedBB box;
        private final CubeCoordinateIterator iterator;
        private final BlockPos.Mutable mutablePos = new BlockPos.Mutable();

        CollisionSpliterator(IBlockReader world, AxisAlignedBB box, CubeCoordinateIterator iterator) {
            super(Long.MAX_VALUE, 1280);
            this.world = world;
            this.box = box;
            this.iterator = iterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super VoxelShape> action) {
            IBlockReader world = this.world;
            CubeCoordinateIterator iterator = this.iterator;
            BlockPos.Mutable mutablePos = this.mutablePos;
            while (iterator.func_218301_a()) {
                int z;
                int y;
                int x = iterator.func_218304_b();
                if (!WaterWalking.canWalkOn(world.func_204610_c((BlockPos)mutablePos.func_181079_c(x, y = iterator.func_218302_c(), z = iterator.func_218303_d()))) || !this.box.func_186668_a((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 0.875, (double)z + 1.0)) continue;
                action.accept((VoxelShape)COLLIDER.func_197751_a((double)x, (double)y, (double)z));
                return true;
            }
            return false;
        }
    }
}

