/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.item.TropicraftItems;

public class HummingbirdEntity
extends AnimalEntity
implements IFlyingAnimal {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int POLLINATE_THRESHOLD = 5;
    private int pollenCollected;

    public HummingbirdEntity(EntityType<? extends HummingbirdEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233822_e_, 0.4).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, world);
        navigator.func_192879_a(false);
        navigator.func_212239_d(true);
        navigator.func_192878_b(true);
        return navigator;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FlyAwayInPanicGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FeedFromPlantsGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new FlyAroundRandomlyGoal());
    }

    public static boolean canHummingbirdSpawnOn(EntityType<HummingbirdEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        BlockState groundState = world.func_180495_p(pos.func_177977_b());
        return (groundState.func_235714_a_((ITag)BlockTags.field_206952_E) || groundState.func_203425_a(Blocks.field_196658_i) || groundState.func_196958_f()) && world.func_226659_b_(pos, 0) > 8;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public HummingbirdEntity createChild(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.HUMMINGBIRD_SPAWN_EGG.get());
    }

    private void tryPollinatePlant(BlockPos pos) {
        if (++this.pollenCollected >= 5) {
            this.pollenCollected = 0;
            this.tryGrowPlant(pos);
        }
    }

    private void tryGrowPlant(BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        IntegerProperty age = this.getPlantAgeProperty(state);
        if (age != null) {
            int nextAge = (Integer)state.func_177229_b((Property)age) + 1;
            if (age.func_177700_c().contains(nextAge)) {
                this.field_70170_p.func_217379_c(2005, pos, 0);
                this.field_70170_p.func_175656_a(pos, (BlockState)state.func_206870_a((Property)age, (Comparable)Integer.valueOf(nextAge)));
            }
        }
    }

    @Nullable
    private IntegerProperty getPlantAgeProperty(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208168_U)) {
            return BlockStateProperties.field_208168_U;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208170_W)) {
            return BlockStateProperties.field_208170_W;
        }
        return null;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74774_a("pollen_collected", (byte)this.pollenCollected);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.pollenCollected = nbt.func_74771_c("pollen_collected");
    }

    abstract class FlyingGoal
    extends Goal {
        final float speed;
        Vector3d target;

        FlyingGoal(float speed) {
            this.speed = speed;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return HummingbirdEntity.this.field_70699_by.func_75500_f();
        }

        public boolean func_75253_b() {
            return HummingbirdEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            this.target = this.generateTarget();
            if (this.target != null) {
                Path path = HummingbirdEntity.this.field_70699_by.func_179680_a(new BlockPos(this.target), 1);
                HummingbirdEntity.this.field_70699_by.func_75484_a(path, (double)this.speed);
            }
        }

        public void func_75251_c() {
            this.target = null;
        }

        @Nullable
        abstract Vector3d generateTarget();

        @Nullable
        final Vector3d generateTargetInDirection(Vector3d direction, double maxAngle) {
            Vector3d target = RandomPositionGenerator.func_226340_a_((CreatureEntity)HummingbirdEntity.this, (int)8, (int)7, (Vector3d)direction, (float)((float)maxAngle), (int)2, (int)1);
            if (target == null) {
                target = RandomPositionGenerator.func_226338_a_((CreatureEntity)HummingbirdEntity.this, (int)8, (int)4, (int)-2, (Vector3d)direction, (double)((float)maxAngle));
            }
            return target;
        }
    }

    final class FlyAroundRandomlyGoal
    extends FlyingGoal {
        FlyAroundRandomlyGoal() {
            super(1.0f);
        }

        @Override
        public boolean func_75250_a() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            return bird.field_70699_by.func_75500_f() && bird.field_70146_Z.nextInt(10) == 0;
        }

        @Override
        @Nullable
        Vector3d generateTarget() {
            Vector3d direction = HummingbirdEntity.this.func_70676_i(1.0f);
            return this.generateTargetInDirection(direction, 1.5707963267948966);
        }
    }

    final class FlyAwayInPanicGoal
    extends FlyingGoal {
        FlyAwayInPanicGoal() {
            super(1.25f);
        }

        @Override
        public boolean func_75250_a() {
            return HummingbirdEntity.this.func_70643_av() != null;
        }

        @Override
        @Nullable
        Vector3d generateTarget() {
            LivingEntity target = HummingbirdEntity.this.func_70643_av();
            if (target == null) {
                return null;
            }
            Vector3d direction = HummingbirdEntity.this.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b();
            return this.generateTargetInDirection(direction, 1.5707963267948966);
        }
    }

    final class FeedFromPlantsGoal
    extends FlyingGoal {
        private static final int SEARCH_TRIES = 50;
        private static final int SEARCH_RADIUS = 5;
        private static final int SEARCH_RADIUS_Y = 3;
        private static final int FEEDING_TICKS = 80;
        private int feedingTicks;
        private boolean foundFood;

        FeedFromPlantsGoal() {
            super(1.0f);
        }

        @Override
        public boolean func_75250_a() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            return bird.field_70699_by.func_75500_f() && bird.field_70146_Z.nextInt(20) == 0;
        }

        @Override
        public boolean func_75253_b() {
            return this.feedingTicks > 0 || HummingbirdEntity.this.func_70781_l();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.feedingTicks = 0;
            this.foundFood = false;
        }

        public void func_75246_d() {
            super.func_75246_d();
            Vector3d target = this.target;
            if (target != null) {
                if (this.foundFood) {
                    this.tickFoundFood(target);
                } else {
                    this.tickFindingFood(target);
                }
            }
        }

        private void tickFoundFood(Vector3d target) {
            if (this.feedingTicks > 0) {
                HummingbirdEntity bird = HummingbirdEntity.this;
                bird.func_70671_ap().func_220674_a(target);
                if (--this.feedingTicks == 0) {
                    bird.tryPollinatePlant(new BlockPos(target));
                }
            }
        }

        private void tickFindingFood(Vector3d target) {
            if (HummingbirdEntity.this.func_195048_a(target) <= 2.25) {
                this.feedingTicks = 80;
                this.foundFood = true;
            }
        }

        @Override
        @Nullable
        Vector3d generateTarget() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            World world = bird.field_70170_p;
            Random random = bird.field_70146_Z;
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            for (int i = 0; i < 50; ++i) {
                mutablePos.func_239621_a_((Vector3i)bird.func_233580_cy_(), random.nextInt(5) - random.nextInt(5), random.nextInt(3) - random.nextInt(3), random.nextInt(5) - random.nextInt(5));
                BlockState state = world.func_180495_p((BlockPos)mutablePos);
                if (!this.canFeedFrom(world, (BlockPos)mutablePos, state)) continue;
                return Vector3d.func_237489_a_((Vector3i)mutablePos);
            }
            return null;
        }

        private boolean canFeedFrom(World world, BlockPos pos, BlockState state) {
            if (this.canFeedFrom(state)) {
                BlockPos.Mutable mutablePos = new BlockPos.Mutable();
                for (Direction direction : HORIZONTALS) {
                    mutablePos.func_239622_a_((Vector3i)pos, direction);
                    if (!world.func_175623_d((BlockPos)mutablePos)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        private boolean canFeedFrom(BlockState state) {
            if (state.func_196958_f()) {
                return false;
            }
            return state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_235714_a_((ITag)BlockTags.field_226149_I_) || state.func_235714_a_((ITag)BlockTags.field_226153_ac_);
        }
    }
}

