/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.item.TropicraftItems;

public final class FiddlerCrabEntity
extends AnimalEntity {
    public FiddlerCrabEntity(EntityType<? extends FiddlerCrabEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.field_70765_h = new CrabMoveController((MobEntity)this);
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickLimbSwing();
    }

    private void tickLimbSwing() {
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.func_226277_ct_() - this.field_70169_q;
        double deltaZ = this.func_226281_cx_() - this.field_70166_s;
        float deltaYaw = MathHelper.func_76142_g((float)(this.field_70761_aq - this.field_70760_ar));
        float move = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float rotate = Math.abs(deltaYaw);
        float targetAmount = move * 4.0f + rotate * 0.25f;
        targetAmount = Math.min(targetAmount, 0.25f);
        this.field_70721_aZ += (targetAmount - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_233629_a_(LivingEntity entity, boolean flying) {
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public FiddlerCrabEntity createChild(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.FIDDLER_CRAB_SPAWN_EGG.get());
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected boolean func_241208_cS_() {
        return !this.field_70122_E;
    }

    public int func_184649_cE() {
        return 30;
    }

    public static boolean canCrabSpawn(EntityType<? extends FiddlerCrabEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        BlockPos groundPos = pos.func_177977_b();
        BlockState groundBlock = world.func_180495_p(groundPos);
        if (groundBlock.func_185904_a() != Material.field_151595_p) {
            return false;
        }
        if (!groundBlock.canCreatureSpawn((IWorldReader)world, groundPos, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, type)) {
            return false;
        }
        BlockState block = world.func_180495_p(pos);
        FluidState fluid = world.func_204610_c(pos);
        return !block.func_235785_r_((IBlockReader)world, pos) && !block.func_185897_m() && !block.func_235714_a_((ITag)BlockTags.field_232884_az_) && (fluid.func_206888_e() || fluid.func_206884_a((ITag)FluidTags.field_206959_a));
    }

    static final class CrabMoveController
    extends MovementController {
        private static final double RAD_TO_DEG = 57.29577951308232;

        CrabMoveController(MobEntity mob) {
            super(mob);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                this.tickMoveTo();
            } else if (this.field_188491_h == MovementController.Action.WAIT) {
                this.field_75648_a.func_191989_p(0.0f);
                this.field_75648_a.func_184646_p(0.0f);
            }
        }

        private void tickMoveTo() {
            double dx = this.field_75646_b - this.field_75648_a.func_226277_ct_();
            double dz = this.field_75644_d - this.field_75648_a.func_226281_cx_();
            double dy = this.field_75647_c - this.field_75648_a.func_226278_cu_();
            double distance2 = dx * dx + dy * dy + dz * dz;
            if (distance2 < 2.5E-7) {
                this.field_75648_a.func_191989_p(0.0f);
                this.field_75648_a.func_184646_p(0.0f);
                return;
            }
            float forward = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float leftTarget = forward - 90.0f;
            float rightTarget = forward + 90.0f;
            float yaw = this.field_75648_a.field_70177_z;
            float targetYaw = CrabMoveController.closerAngle(yaw, leftTarget, rightTarget);
            float speed = (float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_));
            float strafe = targetYaw < forward ? -1.0f : 1.0f;
            this.field_75648_a.field_70177_z = this.func_75639_a(yaw, targetYaw, 10.0f);
            this.field_75648_a.func_70659_e(speed);
            this.field_75648_a.func_191989_p(0.0f);
            this.field_75648_a.func_184646_p(strafe * speed);
        }

        private static float closerAngle(float reference, float left, float right) {
            float deltaRight;
            float deltaLeft = Math.abs(MathHelper.func_76142_g((float)(reference - left)));
            if (deltaLeft < (deltaRight = Math.abs(MathHelper.func_76142_g((float)(reference - right))))) {
                return left;
            }
            return right;
        }
    }
}

