/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class CowktailEntity
extends CowEntity
implements IForgeShearable {
    private static final DataParameter<String> COWKTAIL_TYPE = EntityDataManager.func_187226_a(CowktailEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    public CowktailEntity(EntityType<? extends CowktailEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150391_bh ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COWKTAIL_TYPE, (Object)Type.IRIS.name);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == TropicraftItems.BAMBOO_MUG.get() && !this.func_70631_g_()) {
            if (player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            ArrayList<RegistryObject> cocktails = new ArrayList<RegistryObject>((Collection<RegistryObject>)TropicraftItems.COCKTAILS.values());
            cocktails.removeIf(cocktail -> cocktail.isPresent() && ((CocktailItem)cocktail.get()).getDrink() == Drink.COCKTAIL);
            ItemStack cocktailItem = new ItemStack((IItemProvider)((RegistryObject)cocktails.get(this.field_70146_Z.nextInt(cocktails.size()))).get());
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, cocktailItem);
            } else if (!player.field_71071_by.func_70441_a(cocktailItem)) {
                player.func_71019_a(cocktailItem, false);
            }
            this.func_184185_a(SoundEvents.field_219661_gy, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.getCowktailType().name);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCowktailType(Type.getTypeByName(compound.func_74779_i("Type")));
    }

    private void setCowktailType(Type typeIn) {
        this.field_70180_af.func_187227_b(COWKTAIL_TYPE, (Object)typeIn.name);
    }

    public Type getCowktailType() {
        return Type.getTypeByName((String)this.field_70180_af.func_187225_a(CowktailEntity.COWKTAIL_TYPE));
    }

    public CowktailEntity createChild(ServerWorld world, AgeableEntity ageable) {
        CowktailEntity child = (CowktailEntity)((EntityType)TropicraftEntities.COWKTAIL.get()).func_200721_a(this.field_70170_p);
        child.setCowktailType(this.getOffspringType((CowktailEntity)ageable));
        return child;
    }

    private Type getOffspringType(CowktailEntity p_213445_1_) {
        Type CowktailEntity$type1;
        Type CowktailEntity$type = this.getCowktailType();
        Type CowktailEntity$type2 = CowktailEntity$type == (CowktailEntity$type1 = p_213445_1_.getCowktailType()) && this.field_70146_Z.nextInt(1024) == 0 ? Type.getRandomType(this.field_70146_Z) : (this.field_70146_Z.nextBoolean() ? CowktailEntity$type : CowktailEntity$type1);
        return CowktailEntity$type2;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return !this.func_70631_g_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            CowEntity cowentity = (CowEntity)EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowentity.func_70606_j(this.func_110143_aJ());
            cowentity.field_70761_aq = this.field_70761_aq;
            if (this.func_145818_k_()) {
                cowentity.func_200203_b(this.func_200201_e());
                cowentity.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_217376_c((Entity)cowentity);
            for (int i = 0; i < 5; ++i) {
                ret.add(new ItemStack((IItemProvider)this.getCowktailType().renderState.func_177230_c()));
            }
            this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
        }
        return ret;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData data, @Nullable CompoundNBT nbt) {
        this.setCowktailType(Type.getRandomType(this.field_70146_Z));
        return super.func_213386_a(world, difficultyInstance, spawnReason, data, nbt);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.COWKTAIL_SPAWN_EGG.get());
    }

    public static enum Type {
        IRIS("iris", (BlockState)((TallFlowerBlock)TropicraftBlocks.IRIS.get()).func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER)),
        ANEMONE("anemone", ((FlowerBlock)TropicraftBlocks.FLOWERS.get(TropicraftFlower.ANEMONE).get()).func_176223_P());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        public static Type getRandomType(Random rand) {
            return Type.values()[rand.nextInt(Type.values().length)];
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState getRenderState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type CowktailEntity$type : Type.values()) {
                if (!CowktailEntity$type.name.equals(nameIn)) continue;
                return CowktailEntity$type;
            }
            return IRIS;
        }
    }
}

