/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.entity.projectile.PoisonBlotEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.sound.Sounds;

public class TreeFrogEntity
extends TropicraftCreatureEntity
implements IMob,
IRangedAttackMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(TreeFrogEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private NearestAttackableTargetGoal<PlayerEntity> hostileAI;
    public int jumpDelay = 0;
    private int attackTime;

    public TreeFrogEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.field_70144_Y = 0.8f;
        this.field_70728_aV = 5;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!(this.func_70661_as().func_75500_f() && this.func_70638_az() == null || !this.field_70122_E && !this.func_70090_H())) {
            if (this.jumpDelay > 0) {
                --this.jumpDelay;
            }
            if (this.jumpDelay <= 0) {
                this.jumpDelay = 5 + this.field_70146_Z.nextInt(4);
                Vector3d motion = this.func_213322_ci();
                double speed = Math.sqrt(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c);
                if (speed > 0.02) {
                    double motionY = motion.field_72448_b + 0.4;
                    double motionX = motion.field_72450_a * 1.1;
                    double motionZ = motion.field_72449_c * 1.1;
                    this.func_213293_j(motionX, motionY, motionZ);
                }
            }
        }
        if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)0);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Type", this.getFrogType());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setFrogType(nbt.func_74762_e("Type"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        int type = this.field_70146_Z.nextInt(Type.values().length);
        this.setFrogType(type);
        if (type != 0) {
            this.hostileAI = new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true);
            this.field_70715_bh.func_75776_a(1, this.hostileAI);
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    public void setFrogType(int i) {
        this.field_70180_af.func_187227_b(TYPE, (Object)i);
    }

    public int getFrogType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public String getColor() {
        return Type.values()[this.getFrogType()].getColor();
    }

    public void func_82196_d(LivingEntity entity, float dist) {
        if (dist < 4.0f && !this.field_70170_p.field_72995_K && this.attackTime == 0 && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            double d = entity.func_226277_ct_() - this.func_226277_ct_();
            double d1 = entity.func_226281_cx_() - this.func_226281_cx_();
            PoisonBlotEntity poison = new PoisonBlotEntity((EntityType<? extends ThrowableEntity>)((EntityType)TropicraftEntities.POISON_BLOT.get()), (LivingEntity)this, this.field_70170_p);
            poison.func_70107_b(poison.func_226277_ct_(), poison.func_226278_cu_() + (double)1.4f, poison.func_226281_cx_());
            double shotHeight = entity.func_226278_cu_() + (double)entity.func_70047_e() - (double)0.2f - poison.func_226278_cu_();
            float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1)) * 0.2f;
            entity.func_130014_f_().func_184133_a(null, entity.func_233580_cy_(), Sounds.FROG_SPIT, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)poison);
            poison.func_70186_c(d, shotHeight + (double)f1, d1, 0.6f, 12.0f);
            this.attackTime = 50;
            this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.TREE_FROG_SPAWN_EGG.get());
    }

    public static enum Type {
        GREEN("green"),
        RED("red"),
        BLUE("blue"),
        YELLOW("yellow");

        final String color;

        private Type(String s) {
            this.color = s;
        }

        public String getColor() {
            return this.color;
        }
    }
}

