/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.sound.Sounds;

public class EIHEntity
extends TropicraftCreatureEntity {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(EIHEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public int FLAG_SLEEP = 1;
    public int FLAG_AWARE = 2;
    public int FLAG_ANGRY = 4;

    public EIHEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 10;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.EIH_SPAWN_EGG.get());
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    public byte getState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    private void setState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 100.0).func_233815_a_(Attributes.field_233823_f_, 7.0);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal(this, 1.0, false){

            public boolean func_75250_a() {
                if (!EIHEntity.this.isAngry()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        LeapAtTargetGoal leap = new LeapAtTargetGoal((MobEntity)this, 0.4f);
        this.field_70714_bg.func_75776_a(3, (Goal)leap);
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal(this, 0.8){

            public boolean func_75250_a() {
                if (!EIHEntity.this.isAngry()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new TargetAggressorGoal(this));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("State", this.getState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setState(compound.func_74771_c("State"));
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isAsleep()) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (!this.isAsleep()) {
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (this.field_70173_aa % 20 == 0) {
            LivingEntity attackTarget = this.func_70638_az();
            if (attackTarget == null) {
                PlayerEntity closestPlayer = this.field_70170_p.func_217362_a((Entity)this, 10.0);
                if (closestPlayer != null && !closestPlayer.field_71075_bZ.field_75098_d && !closestPlayer.func_175149_v()) {
                    this.func_70624_b((LivingEntity)closestPlayer);
                }
            } else if (this.func_70032_d((Entity)attackTarget) > 16.0f) {
                this.func_70624_b(null);
                this.setAwake(false);
                this.setImmobile(true);
                this.setAngry(false);
            }
            if (attackTarget != null && !this.func_70781_l() && !this.isAngry() && attackTarget instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)attackTarget;
                if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                    float distance = this.func_70032_d((Entity)player);
                    if (distance < 10.0f) {
                        this.setAwake(true);
                        ItemStack itemstack = player.field_71071_by.func_70448_g();
                        if (!itemstack.func_190926_b() && this.isAware() && itemstack.func_77973_b() == ((Block)TropicraftBlocks.CHUNK.get()).func_199767_j()) {
                            this.setAngry(true);
                            this.setImmobile(false);
                        }
                    }
                    if (this.func_70032_d((Entity)player) < 3.0f && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                        this.setAwake(false);
                        this.setImmobile(false);
                        this.setAngry(true);
                    }
                } else {
                    this.setImmobile(true);
                    this.setAngry(false);
                    this.setAwake(false);
                    this.func_213293_j(0.0, -0.1, 0.0);
                    this.func_70101_b(this.field_70126_B, this.field_70127_C);
                }
            }
            if (this.isAsleep()) {
                this.func_70101_b(this.field_70126_B, this.field_70127_C);
            } else {
                this.setAwake(false);
            }
        }
    }

    public boolean isAngry() {
        return this.getEIHFlag(this.FLAG_ANGRY);
    }

    public void setAngry(boolean angry) {
        this.setEIHFlag(this.FLAG_ANGRY, angry);
    }

    public boolean isAware() {
        return this.getEIHFlag(this.FLAG_AWARE);
    }

    public void setAwake(boolean aware) {
        this.setEIHFlag(this.FLAG_AWARE, aware);
    }

    public boolean isAsleep() {
        return this.getEIHFlag(this.FLAG_SLEEP);
    }

    public void setImmobile(boolean asleep) {
        this.setEIHFlag(this.FLAG_SLEEP, asleep);
    }

    public void setEIHFlag(int id, boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(STATE, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(STATE) | id)));
        } else {
            this.field_70180_af.func_187227_b(STATE, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(STATE) & ~id)));
        }
    }

    private boolean getEIHFlag(int id) {
        return ((Byte)this.field_70180_af.func_187225_a(STATE) & id) != 0;
    }

    protected SoundEvent func_184639_G() {
        if (this.isAware()) {
            return this.field_70146_Z.nextInt(10) == 0 ? Sounds.HEAD_MED : null;
        }
        if (this.isAngry()) {
            return this.field_70146_Z.nextInt(10) == 0 ? Sounds.HEAD_SHORT : null;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return Sounds.HEAD_PAIN;
    }

    protected SoundEvent func_184615_bR() {
        return Sounds.HEAD_DEATH;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.equals(DamageSource.field_76380_i)) {
            return super.func_70097_a(source, amount);
        }
        if (source.func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            if (player.field_71075_bZ.field_75098_d || player.func_175149_v()) {
                return super.func_70097_a(source, amount);
            }
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b().getHarvestLevel(heldItem, ToolType.PICKAXE, player, null) >= 1) {
                return super.func_70097_a(source, amount);
            }
            this.func_184185_a(Sounds.HEAD_LAUGHING, this.func_70599_aP(), this.func_70647_i());
            this.func_70604_c((LivingEntity)player);
            this.setAngry(true);
            this.setImmobile(false);
        }
        return true;
    }

    private static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TargetAggressorGoal(EIHEntity eih) {
            super((MobEntity)eih, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return ((EIHEntity)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }
}

