/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.ashen.AIAshenChaseAndPickupLostMask;
import net.tropicraft.core.common.entity.ai.ashen.AIAshenShootDart;
import net.tropicraft.core.common.entity.ai.ashen.EntityAIMeleeAndRangedAttack;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.BlowGunItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class AshenEntity
extends TropicraftCreatureEntity
implements IRangedAttackMob {
    private static final DataParameter<Byte> MASK_TYPE = EntityDataManager.func_187226_a(AshenEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ACTION_STATE = EntityDataManager.func_187226_a(AshenEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public AshenMaskEntity maskToTrack;

    public AshenEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.setActionState(AshenState.HOSTILE);
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)TropicraftItems.BLOW_GUN.get()));
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)TropicraftItems.DAGGER.get()));
        this.setMaskType((byte)AshenMasks.VALUES[world.func_201674_k().nextInt(AshenMasks.VALUES.length)].ordinal());
        this.setActionState(AshenState.HOSTILE);
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MASK_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(ACTION_STATE, (Object)((byte)AshenState.HOSTILE.ordinal()));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIAshenChaseAndPickupLostMask(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AIAshenShootDart(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new EntityAIMeleeAndRangedAttack(this, 1.0, 40, 200, 5.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityKoaBase.class, true));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public boolean hasMask() {
        return this.getActionState() != AshenState.LOST_MASK;
    }

    public void setMaskType(byte type) {
        this.func_184212_Q().func_187227_b(MASK_TYPE, (Object)type);
    }

    public byte getMaskType() {
        return (Byte)this.func_184212_Q().func_187225_a(MASK_TYPE);
    }

    public void setActionState(AshenState state) {
        this.func_184212_Q().func_187227_b(ACTION_STATE, (Object)((byte)state.ordinal()));
    }

    public AshenState getActionState() {
        return AshenState.VALUES[this.getActionStateValue()];
    }

    private byte getActionStateValue() {
        return (Byte)this.func_184212_Q().func_187225_a(ACTION_STATE);
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        ItemStack headGear = target.func_184582_a(EquipmentSlotType.HEAD);
        if (headGear.func_77973_b() instanceof AshenMaskItem) {
            return;
        }
        ArrowEntity tippedArrow = BlowGunItem.createArrow(this.field_70170_p, (LivingEntity)this, BlowGunItem.getProjectile());
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - tippedArrow.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        tippedArrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, velocity);
        tippedArrow.func_70239_b(1.0);
        tippedArrow.func_70240_a(0);
        this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)tippedArrow);
    }

    public boolean func_70097_a(DamageSource source, float amt) {
        boolean wasHit = super.func_70097_a(source, amt);
        if (!this.field_70170_p.field_72995_K && this.hasMask() && wasHit && !source.equals(DamageSource.field_76380_i)) {
            this.dropMask();
        }
        return wasHit;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74774_a("MaskType", this.getMaskType());
        nbt.func_74774_a("ActionState", this.getActionStateValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setMaskType(nbt.func_74771_c("MaskType"));
        this.setActionState(AshenState.VALUES[nbt.func_74771_c("ActionState")]);
    }

    public void dropMask() {
        this.setActionState(AshenState.LOST_MASK);
        this.maskToTrack = new AshenMaskEntity((EntityType)TropicraftEntities.ASHEN_MASK.get(), this.field_70170_p);
        this.maskToTrack.setMaskType(this.getMaskType());
        this.maskToTrack.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
        this.field_70170_p.func_217376_c((Entity)this.maskToTrack);
    }

    public void pickupMask(AshenMaskEntity mask) {
        this.setActionState(AshenState.HOSTILE);
        this.maskToTrack = null;
        this.setMaskType(mask.getMaskType());
        mask.func_70106_y();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.ASHEN_SPAWN_EGG.get());
    }

    public static enum AshenState {
        PEACEFUL,
        LOST_MASK,
        HOSTILE;

        public static final AshenState[] VALUES;

        static {
            VALUES = AshenState.values();
        }
    }
}

