/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import com.google.common.collect.ImmutableList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.HandSide;
import net.minecraft.world.World;

public abstract class EggEntity
extends LivingEntity {
    private static final DataParameter<Integer> HATCH_DELAY = EntityDataManager.func_187226_a(EggEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public double rotationRand = 0.0;

    public EggEntity(EntityType<? extends EggEntity> type, World w) {
        super(type, w);
        this.field_70158_ak = true;
        this.field_70177_z = this.field_70146_Z.nextInt(360);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 2.0);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.field_70173_aa = compound.func_74762_e("ticks");
        this.setHatchDelay(compound.func_74762_e("hatchDelay"));
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("ticks", this.field_70173_aa);
        compound.func_74768_a("hatchDelay", this.getHatchDelay());
        super.func_213281_b(compound);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HATCH_DELAY, (Object)0);
        this.setHatchDelay(-60 + this.field_70146_Z.nextInt(120));
    }

    public abstract boolean shouldEggRenderFlat();

    public abstract String getEggTexture();

    public abstract Entity onHatch();

    public abstract int getHatchTime();

    public abstract int getPreHatchMovement();

    public int getRandomHatchDelay() {
        return (Integer)this.func_184212_Q().func_187225_a(HATCH_DELAY);
    }

    public boolean isHatching() {
        return this.field_70173_aa > this.getHatchTime() + this.getRandomHatchDelay();
    }

    public boolean isNearHatching() {
        return this.field_70173_aa > this.getHatchTime() + this.getRandomHatchDelay() - this.getPreHatchMovement();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isNearHatching()) {
            this.rotationRand += (double)(0.1707f * this.field_70170_p.field_73012_v.nextFloat());
            if (this.field_70173_aa >= this.getHatchTime() && !this.field_70170_p.field_72995_K) {
                Entity ent = this.onHatch();
                ent.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c(ent);
                this.func_70106_y();
            }
        }
    }

    public void setHatchDelay(int i) {
        this.func_184212_Q().func_187227_b(HATCH_DELAY, (Object)(-60 + this.field_70146_Z.nextInt(120)));
    }

    public int getHatchDelay() {
        return (Integer)this.func_184212_Q().func_187225_a(HATCH_DELAY);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return ImmutableList.of();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }
}

