/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class MonkeyAngryThrowGoal
extends Goal {
    private final VMonkeyEntity entity;
    private final float speedModifier;
    private final float stopDistance;
    private final PathNavigator navigation;
    private float oldWaterCost;
    private int timeToRecalcPath;
    private int madMeter;
    private ItemEntity trackedMug;
    private LivingEntity trackedPlayer;

    public MonkeyAngryThrowGoal(VMonkeyEntity monkeyEntity) {
        this.entity = monkeyEntity;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.speedModifier = 1.2f;
        this.stopDistance = 1.0f;
        this.navigation = monkeyEntity.func_70661_as();
    }

    public void func_75251_c() {
        this.navigation.func_75499_g();
        this.madMeter = 0;
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        this.trackedMug = null;
        this.trackedPlayer = null;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.madMeter = 100;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
        this.trackedMug = null;
        this.trackedPlayer = null;
    }

    public boolean func_75250_a() {
        return !this.entity.func_70909_n() && !this.entity.func_110167_bD() && this.entity.isMadAboutStolenAlcohol();
    }

    public boolean func_75253_b() {
        return !this.entity.func_70909_n() && !this.entity.func_110167_bD() && this.entity.isMadAboutStolenAlcohol();
    }

    public void func_75246_d() {
        if (this.trackedMug != null && this.entity.func_184614_ca().func_77973_b() == ((Item)TropicraftItems.BAMBOO_MUG.get()).getItem()) {
            this.trackedPlayer = this.nearbyPlayer();
            if (this.trackedPlayer != null) {
                this.entity.func_70671_ap().func_75651_a((Entity)this.trackedPlayer, 10.0f, (float)this.entity.func_70646_bf());
                if (this.entity.func_70068_e((Entity)this.trackedPlayer) < 4.0) {
                    this.leapTowardTarget(this.trackedPlayer);
                    this.entity.func_199701_a_(this.entity.func_184614_ca());
                    this.entity.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    this.entity.setMadAboutStolenAlcohol(false);
                } else {
                    this.moveTowardsEntity((Entity)this.trackedPlayer);
                }
            }
            return;
        }
        if (this.trackedMug != null && this.trackedMug.func_70089_S()) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.trackedMug, 10.0f, (float)this.entity.func_70646_bf());
            if (this.entity.func_70068_e((Entity)this.trackedMug) > (double)(this.stopDistance * this.stopDistance)) {
                this.moveTowardsEntity((Entity)this.trackedMug);
            } else {
                this.entity.func_184611_a(Hand.MAIN_HAND, this.trackedMug.func_92059_d());
                this.trackedMug.func_70106_y();
            }
            return;
        }
        if (--this.madMeter <= 0) {
            this.entity.setMadAboutStolenAlcohol(false);
            return;
        }
        this.trackedMug = this.nearbyMug();
    }

    private LivingEntity nearbyPlayer() {
        List list = this.entity.field_70170_p.func_217357_a(PlayerEntity.class, this.entity.func_174813_aQ().func_186662_g(20.0));
        if (!list.isEmpty()) {
            for (PlayerEntity entityliving : list) {
                if (entityliving.func_82150_aj()) continue;
                return entityliving;
            }
        }
        return null;
    }

    private void moveTowardsEntity(Entity itemEntity) {
        if (--this.timeToRecalcPath <= 0) {
            double d2;
            double d1;
            this.timeToRecalcPath = 10;
            double d0 = this.entity.func_226277_ct_() - itemEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = this.entity.func_226278_cu_() - itemEntity.func_226278_cu_()) * d1 + (d2 = this.entity.func_226281_cx_() - itemEntity.func_226281_cx_()) * d2;
            if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                this.navigation.func_75497_a(itemEntity, (double)this.speedModifier);
            } else {
                this.navigation.func_75499_g();
                if (d3 <= (double)this.stopDistance) {
                    double d4 = itemEntity.func_226277_ct_() - this.entity.func_226277_ct_();
                    double d5 = itemEntity.func_226281_cx_() - this.entity.func_226281_cx_();
                    this.navigation.func_75492_a(this.entity.func_226277_ct_() - d4, this.entity.func_226278_cu_(), this.entity.func_226281_cx_() - d5, (double)this.speedModifier);
                }
            }
        }
    }

    private void leapTowardTarget(LivingEntity leapTarget) {
        if (leapTarget == null) {
            return;
        }
        double d0 = leapTarget.func_226277_ct_() - this.entity.func_226277_ct_();
        double d1 = leapTarget.func_226281_cx_() - this.entity.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        Vector3d motion = this.entity.func_213322_ci();
        if ((double)f >= 1.0E-4) {
            this.entity.func_213317_d(motion.func_72441_c(d0 / (double)f * 0.5 * (double)0.8f + motion.field_72450_a * (double)0.2f, 0.0, d1 / (double)f * 0.5 * (double)0.8f + motion.field_72449_c * (double)0.2f));
        }
        this.entity.func_213317_d(new Vector3d(motion.field_72450_a, 0.25, motion.field_72449_c));
    }

    private ItemEntity nearbyMug() {
        List list = this.entity.field_70170_p.func_217357_a(ItemEntity.class, this.entity.func_174813_aQ().func_186662_g(10.0));
        if (!list.isEmpty()) {
            for (ItemEntity item : list) {
                if (item.func_82150_aj() || !item.func_92059_d().func_77969_a(new ItemStack((IItemProvider)TropicraftItems.BAMBOO_MUG.get())) || !item.func_70089_S()) continue;
                return item;
            }
        }
        return null;
    }
}

