/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.ashen;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.item.AshenMaskItem;

public class EntityAIMeleeAndRangedAttack
extends Goal {
    private final AshenEntity entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private double entityMoveSpeed;
    private int seeTime;
    private int maxMeleeAttackTime;
    private int maxRangedAttackTime;
    private float shootCutoffRange;
    private float shootCutoffRangeSqr;
    private float meleeHitRange = 2.0f;

    public EntityAIMeleeAndRangedAttack(AshenEntity attacker, double movespeed, int maxMeleeAttackTime, int maxRangedAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxMeleeAttackTime, maxRangedAttackTime, maxAttackDistanceIn, 2.0f);
    }

    public EntityAIMeleeAndRangedAttack(AshenEntity attacker, double movespeed, int maxMeleeAttackTime, int maxRangedAttackTime, float maxAttackDistanceIn, float meleeHitRange) {
        this.rangedAttackEntityHost = attacker;
        this.entityHost = attacker;
        this.entityMoveSpeed = movespeed;
        this.maxMeleeAttackTime = maxMeleeAttackTime;
        this.maxRangedAttackTime = maxRangedAttackTime;
        this.shootCutoffRange = maxAttackDistanceIn;
        this.shootCutoffRangeSqr = maxAttackDistanceIn * maxAttackDistanceIn;
        this.meleeHitRange = meleeHitRange;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity entitylivingbase = this.entityHost.func_70643_av();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        ItemStack headGear;
        if (this.attackTarget != null && (headGear = this.attackTarget.func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof AshenMaskItem) {
            return;
        }
        double d0 = this.entityHost.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.func_226281_cx_());
        boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 <= (double)this.shootCutoffRangeSqr) || this.seeTime >= 20) {
            // empty if block
        }
        if (this.seeTime >= 20) {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime <= 0) {
            float f;
            float f1 = f = MathHelper.func_76133_a((double)d0) / this.shootCutoffRange;
            if (f < 0.1f) {
                f1 = 0.1f;
            }
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (d0 >= (double)this.shootCutoffRange * (double)this.shootCutoffRange) {
                this.rangedAttackEntityHost.func_82196_d(this.attackTarget, f1);
                this.rangedAttackTime = this.maxRangedAttackTime;
            } else if (d0 <= (double)(this.meleeHitRange * this.meleeHitRange)) {
                this.entityHost.func_70652_k((Entity)this.attackTarget);
                this.entityHost.func_184609_a(Hand.MAIN_HAND);
                this.rangedAttackTime = this.maxMeleeAttackTime;
            }
        }
    }
}

