/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAITemptHelmet
extends Goal {
    private final CreatureEntity temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private PlayerEntity temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Set<RegistryObject<Item>> temptItem;
    private final boolean scaredByPlayerMovement;

    public EntityAITemptHelmet(CreatureEntity temptedEntityIn, double speedIn, RegistryObject<Item> temptItemIn, boolean scaredByPlayerMovementIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, Sets.newHashSet((Object[])new RegistryObject[]{temptItemIn}));
    }

    public EntityAITemptHelmet(CreatureEntity temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, Set<RegistryObject<Item>> temptItemIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.scaredByPlayerMovement = scaredByPlayerMovementIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(temptedEntityIn.func_70661_as() instanceof GroundPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.temptedEntity instanceof EntityKoaBase && ((EntityKoaBase)this.temptedEntity).druggedTime <= 0) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_217362_a((Entity)this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        return this.isTempting((ItemStack)this.temptingPlayer.field_71071_by.field_70460_b.get(3));
    }

    protected boolean isTempting(ItemStack stack) {
        for (RegistryObject<Item> items : this.temptItem) {
            if (!items.isPresent() || ((Item)items.get()).getItem() != stack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.field_70125_A - this.pitch) > 5.0 || Math.abs((double)this.temptingPlayer.field_70177_z - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.func_226277_ct_();
                this.targetY = this.temptingPlayer.func_226278_cu_();
                this.targetZ = this.temptingPlayer.func_226281_cx_();
            }
            this.pitch = this.temptingPlayer.field_70125_A;
            this.yaw = this.temptingPlayer.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.func_226277_ct_();
        this.targetY = this.temptingPlayer.func_226278_cu_();
        this.targetZ = this.temptingPlayer.func_226281_cx_();
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.delayTemptCounter = 100;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.func_70661_as().func_75499_g();
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

