/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityAIChillAtFire
extends Goal {
    private final EntityKoaBase entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private int randXPos = 0;
    private int randYPos = 0;
    private int randZPos = 0;

    public EntityAIChillAtFire(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if ((this.entityObj.getWantsToParty() || this.entityObj.druggedTime > 0) && this.entityObj.listPosDrums.size() > 0) {
            return false;
        }
        BlockPos blockpos = this.entityObj.func_233580_cy_();
        if (!this.entityObj.field_70170_p.func_72935_r() || this.entityObj.field_70170_p.func_72896_J() && this.entityObj.field_70170_p.func_226691_t_(blockpos).func_201851_b() != Biome.RainType.RAIN) {
            if (!this.isTooClose()) {
                return this.entityObj.field_70170_p.field_73012_v.nextInt(20) == 0;
            }
            return false;
        }
        return false;
    }

    public boolean func_75253_b() {
        if ((this.entityObj.getWantsToParty() || this.entityObj.druggedTime > 0) && this.entityObj.listPosDrums.size() > 0) {
            return false;
        }
        BlockPos blockpos = this.entityObj.func_233580_cy_();
        if (!this.entityObj.field_70170_p.func_72935_r() || this.entityObj.field_70170_p.func_72896_J() && this.entityObj.field_70170_p.func_226691_t_(blockpos).func_201851_b() != Biome.RainType.RAIN) {
            return !this.isTooClose();
        }
        return this.entityObj.field_70170_p.field_73012_v.nextInt(60) != 0;
    }

    public void func_75246_d() {
        super.func_75246_d();
        boolean isClose = false;
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.func_177982_a(0, -1, 0) : this.entityObj.func_213384_dI();
        if (blockposGoal == null) {
            this.func_75251_c();
            return;
        }
        double dist = this.entityObj.func_213303_ch().func_72438_d(new Vector3d((double)blockposGoal.func_177958_n(), (double)blockposGoal.func_177956_o(), (double)blockposGoal.func_177952_p()));
        if (dist < 4.0 && this.entityObj.func_233570_aj_()) {
            this.entityObj.setSitting(true);
            this.entityObj.func_70661_as().func_75499_g();
            isClose = true;
            if (this.lookUpdateTimer <= 0) {
                this.lookUpdateTimer = 200 + this.entityObj.field_70170_p.field_73012_v.nextInt(100);
                int range = 2;
                this.randXPos = this.entityObj.field_70170_p.field_73012_v.nextInt(range) - this.entityObj.field_70170_p.field_73012_v.nextInt(range);
                this.randYPos = this.entityObj.field_70170_p.field_73012_v.nextInt(3) == 0 ? 5 + this.entityObj.field_70170_p.field_73012_v.nextInt(5) : 0;
                this.randZPos = this.entityObj.field_70170_p.field_73012_v.nextInt(range) - this.entityObj.field_70170_p.field_73012_v.nextInt(range);
                if (this.entityObj.func_145782_y() % 3 == 0) {
                    this.entityObj.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TropicraftItems.BAMBOO_MUG.get()));
                } else if (this.entityObj.func_145782_y() % 5 == 0) {
                    this.entityObj.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TropicraftItems.COOKED_FROG_LEG.get()));
                } else {
                    this.entityObj.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TropicraftItems.ORANGE.get()));
                }
                this.entityObj.func_70691_i(1.0f);
            }
            this.entityObj.func_70671_ap().func_75650_a((double)(blockposGoal.func_177958_n() + this.randXPos), (double)(blockposGoal.func_177956_o() + this.randYPos) + 1.0, (double)(blockposGoal.func_177952_p() + this.randZPos), 8.0f, 8.0f);
        } else {
            this.entityObj.setSitting(false);
        }
        if (!isClose) {
            if ((this.entityObj.func_70661_as().func_75500_f() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                Vector3d Vector3d2;
                int i = blockposGoal.func_177958_n();
                int j = blockposGoal.func_177956_o();
                int k = blockposGoal.func_177952_p();
                boolean success = false;
                success = this.entityObj.func_195048_a(Vector3d.func_237489_a_((Vector3i)blockposGoal)) > 256.0 ? ((Vector3d2 = RandomPositionGenerator.func_234133_a_((CreatureEntity)this.entityObj, (int)14, (int)3, (Vector3d)new Vector3d((double)i + 0.5, (double)j, (double)k + 0.5))) != null ? this.entityObj.func_70661_as().func_75492_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, 1.0) : Util.tryMoveToXYZLongDist((MobEntity)this.entityObj, new BlockPos(i, j, k), 1.0)) : this.entityObj.func_70661_as().func_75492_a((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                if (!success) {
                    this.repathPentalty = 40;
                } else {
                    this.walkingTimeout = this.walkingTimeoutMax;
                }
            } else if (this.walkingTimeout > 0) {
                --this.walkingTimeout;
            }
        }
        if (this.repathPentalty > 0) {
            --this.repathPentalty;
        }
        if (this.lookUpdateTimer > 0) {
            --this.lookUpdateTimer;
        }
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entityObj.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.func_177982_a(0, -1, 0) : this.entityObj.func_213384_dI();
        if (blockposGoal == null) {
            return false;
        }
        double dist = this.entityObj.func_213303_ch().func_72438_d(new Vector3d((double)blockposGoal.func_177958_n(), (double)blockposGoal.func_177956_o(), (double)blockposGoal.func_177952_p()));
        return dist <= 3.0;
    }
}

